/**
 * Diese Klasse repraesentiert ein Fahrzeug.
 * 
 * @author Annabelle Klarl
 * 
 */
public class Fahrzeug {
	private Point position;
	private int anzahlRaeder;
	private double leergewicht;
	private double aktuelleGeschwindigkeit;

	/**
	 * Konstruktor eine Fahrzeugs, wobei die Position des Fahrzeugs, die Anzahl
	 * der Raeder, das Leergewicht und die aktuelle Geschwindigkeit des
	 * Fahrzeugs gegeben sein muessen.
	 * 
	 * @param x
	 *            x-Koordinate der Position des Fahrzeugs
	 * @param y
	 *            y-Koordinate der Position des Fahrzeugs
	 * @param anzahlRaeder
	 *            die Anzahl der Raeder des Fahrzeugs
	 * @param leergewicht
	 *            das Leergewicht des Fahrzeugs
	 * @param aktuelleGeschwindigkeit
	 *            die aktuelle Anfangsgeschwindigkeit des Fahrzeugs
	 */
	public Fahrzeug(int x, int y, int anzahlRaeder, double leergewicht,
			double aktuelleGeschwindigkeit) {
		this.position = new Point(x, y);
		this.anzahlRaeder = anzahlRaeder;
		this.leergewicht = leergewicht;
		this.aktuelleGeschwindigkeit = aktuelleGeschwindigkeit;
	}

	/**
	 * Diese Methode beschleunigt das Fahrzeug um die angegebene
	 * Geschwindigkeit.
	 * 
	 * @param beschleunigung
	 *            die Geschwindigkeit, um die das Fahrzeug beschleunigt werden
	 *            soll
	 */
	public void beschleunigen(double beschleunigung) {
		this.aktuelleGeschwindigkeit = this.aktuelleGeschwindigkeit
				+ beschleunigung;
	}

	/**
	 * Diese Methode bewegt den Mittelpunkt des Fahrzeugs
	 * 
	 * @param dx
	 *            Versatz in x-Richtung
	 * @param dy
	 *            Versatz in y-Richtung
	 */
	public void fahren(int dx, int dy) {
		this.position.move(dx, dy);
	}

	/**
	 * Diese Methode gibt die aktuelle Geschwindigkeit des Fahrzeugs zurueck
	 * 
	 * @return die aktuelle Geschwindigkeit
	 */
	public double getAktuelleGeschwindigkeit() {
		return this.aktuelleGeschwindigkeit;
	}
}
