/**
 * Diese Klasse repraesentiert eine geometrische Figur.
 */
public class Figur {
	private Point mittelpunkt;
	private String farbe;
	private boolean ausgefuellt;

	/**
	 * Konstruktor einer geometrischen Figur, wobei deren Mittelpunkt und die
	 * Farbe gegeben sein muessen sowie ob die Figur ausgefuellt ist oder nicht.
	 * 
	 * @param p
	 *            der Mittelpunkt der Figur
	 * @param farbe
	 *            die Farbe der Figur
	 * @param ausgefuellt
	 *            ob die Figur ausgefuellt ist oder nicht
	 */
	public Figur(Point p, String farbe, boolean ausgefuellt) {
		this.mittelpunkt = p;
		this.farbe = farbe;
		this.ausgefuellt = ausgefuellt;
	}

	/**
	 * Konstruktor einer geometrischen Figur, wobei deren Mittelpunkt und die
	 * Farbe gegeben sein muessen sowie ob die Figur ausgefuellt ist oder nicht.
	 * 
	 * @param x
	 *            x-Koordinate des Mittelpunkts der Figur
	 * @param y
	 *            y-Koordinate des Mittelpunkts der Figur
	 * @param farbe
	 *            die Farbe der Figur
	 * @param ausgefuellt
	 *            ob die Figur ausgefuellt ist oder nicht
	 */
	public Figur(int x, int y, String farbe, boolean ausgefuellt) {
		this.mittelpunkt = new Point(x, y);
		this.farbe = farbe;
		this.ausgefuellt = ausgefuellt;
	}

	/**
	 * Diese Methode versetzt den Mittelpunkt der Figur
	 * 
	 * @param dx
	 *            Versatz in x-Richtung
	 * @param dy
	 *            Versatz in y-Richtung
	 */
	public void bewegen(int dx, int dy) {
		this.mittelpunkt.move(dx, dy);
	}

	/**
	 * Diese Methode gibt den Mittelpunkt der Figur zurueck
	 * 
	 * @return der Mittelpunkt
	 */
	public Point getMittelpunkt() {
		return this.mittelpunkt;
	}
}
