/**
 * Diese Klasse repraesentiert einen Punkt in der Ebene.
 * @author David Sabel
 * @version 1.0
 */
public class Point {
        private int x,y;
        /**
         * Konstruktor eines Punkts.
         * wobei dessen x- und y-Koordinate gegeben sein muessen.
         * @param x0
         *    x-Koordinate des Punkts
         * @param y0
         *    y-Koordinate des Punkts
         */
        public Point(int x0, int y0){
                this.x = x0;
                this.y = y0;
        }
        /**
         * Diese Methode verschiebt den Punkt um dx auf der x-Achse
         * und dy auf der y-Achse
         * @param dx
         *    Distanz der Verschiebung auf der x-Achse
         * @param dy
         *    Distanz der Verschiebung auf der y-Achse
         */
        public void move(int dx, int dy){
                this.x += dx;
                this.y += dy;
        }
        /**
         * Diese Methode liefert die x-Koordinate des Punkts zurueck
         * @return 
         *   die x-Koordinate des Punkts
         */
        public int getX(){
                return this.x;
        }
        /**
         * Diese Methode liefert die y-Koordinate des Punkts zurueck
         * @return 
         *   die y-Koordinate des Punkts
         */
        public int getY(){
                return this.y;
        }
}  
