import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/**
 * Dieses Programm zeigt ein einfaches Fenster mit zwei Textfeldern an, in die jeweils eine Zahl
 * eingegeben werden kann. Nachdem der Summe-Button gedrueckt wurde, wird die Summe der beiden
 * Zahlen im Ausgabe-Bereich ausgegeben. Nachdem der Produkt-Button gedrueckt wurde, wird das
 * Produkt der beiden Zahlen im Ausgabe-Bereich ausgegeben.
 *
 * @author Annabelle Klarl
 */
public class BerechnungsFrameGridLayoutEinzeln extends JFrame implements ActionListener {

  /**
   * Dieses Programmstueck startet das Programm.
   *
   * @param args
   */
  public static void main(String[] args) {
    BerechnungsFrameGridLayoutEinzeln berechnung = new BerechnungsFrameGridLayoutEinzeln();
    berechnung.setVisible(true);
  }

  private JLabel zahl1EingabeLabel;
  private JTextField zahl1EingabeFeld;

  private JLabel zahl2EingabeLabel;
  private JTextField zahl2EingabeFeld;

  private JButton summeButton;
  private JButton produktButton;

  private JTextArea ausgabeBereich;

  /**
   * In diesem Programmstueck wird das Fenster erzeugt. Auf dem Fenster sind spaeter zwei Textfelder
   * zu sehen, in denen jeweils nach einer Zahl gefragt wird. Ausserdem gibt es einen Summe-Button
   * und einen Produkt-Button, der die Berechnung der Summe bzw. des Produkts der beiden Zahlen
   * startet. Die Summe bzw. das Produkt werden in einem Ausgabe-Bereich angezeigt.
   */
  public BerechnungsFrameGridLayoutEinzeln() {
    /* In der Kopfleiste des Fenster steht "Berechnung" */
    this.setTitle("Berechnung");

    /* Das Fenster ist 350 Pixel breit und 150 Pixel hoch. */
    this.setSize(350, 150);

    /* Initialisierung aller Attribute */
    this.zahl1EingabeLabel = new JLabel("1. Zahl:");
    this.zahl1EingabeFeld = new JTextField(25);
    this.zahl2EingabeLabel = new JLabel("2. Zahl:");
    this.zahl2EingabeFeld = new JTextField(25);
    this.summeButton = new JButton("Summe");
    this.produktButton = new JButton("Produkt");
    this.ausgabeBereich = new JTextArea(3, 33);

    /*
     * Der ContentPane ist der Ausschnitt des Fensters, auf dem Widgets d.h.
     * Interaktionselemente (wie ein Textfeld oder ein Button) platziert
     * werden koennen.
     */
    Container contentPane = this.getContentPane();
    contentPane.setLayout(new GridLayout(4, 2));

    /* Hier werden alle Interaktionselemente platziert */
    contentPane.add(this.zahl1EingabeLabel);
    contentPane.add(this.zahl1EingabeFeld);
    contentPane.add(this.zahl2EingabeLabel);
    contentPane.add(this.zahl2EingabeFeld);
    contentPane.add(this.summeButton);
    contentPane.add(this.produktButton);
    contentPane.add(this.ausgabeBereich);

    /*
     * Hier wird dieser BerechnungsFrame als Listener fuer
     * Knopfdruckereignisse bei jedem der zwei Buttons registriert.
     */
    this.summeButton.addActionListener(this);
    this.produktButton.addActionListener(this);

    /*
     * Wird das Fenster geschlossen (d.h. auf X gedrueckt), wird mit Hilfe
     * dieser Programmzeile auch unser Programm ordnungsgemaess beendet.
     */
    this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
  }

  /**
   * Dieses Programmstueck wird immer dann ausgefuehrt, wenn ein Benutzer auf einen Button drueckt.
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    Object source = e.getSource();
    if (source == this.summeButton) {
      this.summiere();
    } else if (source == this.produktButton) {
      this.multipliziere();
    }
  }

  /**
   * In diesem Programmstueck werden die Zahlen in den Feldern zahl1EingabeFeld und zahl2EingabeFeld
   * als Strings gelesen. Beide Strings werden in Zahlen (int) konvertiert, anschliessend addiert
   * und die Summe ausgegeben.
   */
  private void summiere() {
    String zahl1AlsString = this.zahl1EingabeFeld.getText();
    int zahl1 = Integer.parseInt(zahl1AlsString);

    String zahl2AlsString = this.zahl2EingabeFeld.getText();
    int zahl2 = Integer.parseInt(zahl2AlsString);

    int summe = zahl1 + zahl2;

    this.ausgabeBereich.setText("Die Summe ist " + summe + ".");
  }

  /**
   * In diesem Programmstueck werden die Zahlen in den Feldern zahl1EingabeFeld und zahl2EingabeFeld
   * als Strings gelesen. Beide Strings werden in Zahlen (int) konvertiert, anschliessend
   * multipliziert und das Produkt ausgegeben.
   */
  private void multipliziere() {
    String zahl1AlsString = this.zahl1EingabeFeld.getText();
    int zahl1 = Integer.parseInt(zahl1AlsString);

    String zahl2AlsString = this.zahl2EingabeFeld.getText();
    int zahl2 = Integer.parseInt(zahl2AlsString);

    int produkt = zahl1 * zahl2;

    this.ausgabeBereich.setText("Das Produkt ist " + produkt + ".");
  }
}
