/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public abstract class FileContent {
    public abstract String getFileLocation();

    public abstract long getContentsHash();

    public static FileContent create(String filePath, char[] contents) {
        return new InternalFileContent(filePath, new CharArray(contents));
    }

    public static FileContent create(ITranslationUnit tu) {
        IPath location = tu.getLocation();
        if (location == null) {
            return FileContent.create(tu.getElementName(), tu.getContents());
        }
        if (tu.isWorkingCopy()) {
            return FileContent.create(location.toOSString(), tu.getContents());
        }
        IResource res = tu.getResource();
        if (res instanceof IFile) {
            return FileContent.create((IFile)res);
        }
        return FileContent.createForExternalFileLocation(location.toOSString());
    }

    public static FileContent create(IIndexFileLocation ifl) {
        return InternalParserUtil.createFileContent(ifl);
    }

    public static FileContent create(IFile file) {
        return InternalParserUtil.createWorkspaceFileContent(file);
    }

    public static FileContent createForExternalFileLocation(String fileLocation) {
        return FileContent.createForExternalFileLocation(fileLocation, InternalParserUtil.SYSTEM_DEFAULT_ENCODING);
    }

    public static FileContent createForExternalFileLocation(String fileLocation, String encoding) {
        return InternalParserUtil.createExternalFileContent(fileLocation, encoding);
    }

    @Deprecated
    public static FileContent adapt(CodeReader reader) {
        if (reader == null) {
            return null;
        }
        return FileContent.create(reader.getPath(), reader.buffer);
    }
}

