/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPEnumerator
extends PDOMCPPBinding
implements IEnumerator {
    private static final int VALUE = 28;
    protected static final int RECORD_SIZE = 32;

    public PDOMCPPEnumerator(PDOMLinkage linkage, PDOMNode parent, IEnumerator enumerator) throws CoreException {
        super(linkage, parent, enumerator.getNameCharArray());
        this.storeValue(enumerator);
    }

    public PDOMCPPEnumerator(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    protected int getRecordSize() {
        return 32;
    }

    public int getNodeType() {
        return 16;
    }

    private void storeValue(IEnumerator enumerator) throws CoreException {
        IValue value = enumerator.getValue();
        if (value != null) {
            Long val = value.numericalValue();
            this.getDB().putInt(this.record + 28L, val == null ? -1 : val.intValue());
        }
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IEnumerator) {
            this.storeValue((IEnumerator)newBinding);
        }
    }

    public IType getType() throws DOMException {
        IIndexBinding owner = this.getOwner();
        if (owner instanceof IType) {
            return (IType)((Object)owner);
        }
        return null;
    }

    public IValue getValue() {
        try {
            int val = this.getDB().getInt(this.record + 28L);
            return Value.create(val);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return Value.UNKNOWN;
        }
    }
}

