/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.dwarf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.dwarf.Dwarf;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfReader
extends Dwarf
implements ISymbolReader {
    static final String[] DWARF_SectionsToParse = new String[]{".debug_info", ".debug_line", ".debug_abbrev", ".debug_str"};
    private final Collection<String> m_fileCollection = new ArrayList<String>();
    private String[] m_fileNames = null;
    private boolean m_parsed = false;
    private final ArrayList<Integer> m_parsedLineTableOffsets = new ArrayList();
    private int m_parsedLineTableSize = 0;

    public DwarfReader(String file) throws IOException {
        super(file);
    }

    public DwarfReader(Elf exe) throws IOException {
        super(exe);
    }

    public DwarfReader(PE exe) throws IOException {
        super(exe);
    }

    @Override
    public void init(Elf exe) throws IOException {
        Elf.Section[] sections;
        Elf.ELFhdr header = exe.getELFhdr();
        this.isLE = header.e_ident[5] == 1;
        Elf.Section[] sectionArray = sections = exe.getSections();
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            Elf.Section section = sectionArray[n2];
            String name = section.toString();
            String[] stringArray = DWARF_SectionsToParse;
            int n3 = DWARF_SectionsToParse.length;
            int n4 = 0;
            while (n4 < n3) {
                String element = stringArray[n4];
                if (name.equals(element)) {
                    try {
                        this.dwarfSections.put(element, section.mapSectionData());
                    }
                    catch (Exception e) {
                        CCorePlugin.log(e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        this.printEnabled = false;
        this.m_parsed = false;
    }

    @Override
    public void init(PE exe) throws IOException {
        this.isLE = true;
        Coff.SectionHeader[] sections = exe.getSectionHeaders();
        int i = 0;
        while (i < sections.length) {
            String name = new String(sections[i].s_name).trim();
            if (name.startsWith("/")) {
                int stringTableOffset = Integer.parseInt(name.substring(1));
                name = exe.getStringTableEntry(stringTableOffset);
            }
            String[] stringArray = Dwarf.DWARF_SCNNAMES;
            int n = Dwarf.DWARF_SCNNAMES.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (name.equals(element)) {
                    try {
                        this.dwarfSections.put(element, sections[i].mapSectionData());
                    }
                    catch (Exception e) {
                        CCorePlugin.log(e);
                    }
                }
                ++n2;
            }
            ++i;
        }
        this.printEnabled = false;
        this.m_parsed = false;
    }

    void parseSourceInCULineInfo(String cuCompDir, int cuStmtList) {
        ByteBuffer data = (ByteBuffer)this.dwarfSections.get(".debug_line");
        if (data != null) {
            try {
                String fileName;
                String str;
                data.position(cuStmtList);
                Integer cuOffset = new Integer(cuStmtList);
                if (!this.m_parsedLineTableOffsets.contains(cuOffset)) {
                    this.m_parsedLineTableOffsets.add(cuOffset);
                    int length = this.read_4_bytes(data) + 4;
                    this.m_parsedLineTableSize += length + 4;
                } else {
                    return;
                }
                data.position(data.position() + 10);
                byte opcode_base = data.get();
                data.position(data.position() + opcode_base - 1);
                ArrayList<String> dirList = new ArrayList<String>();
                dirList.add(cuCompDir);
                while ((str = this.readString(data)).length() != 0) {
                    Path dir = new Path(str);
                    if (!dir.isAbsolute()) {
                        dir = new Path(cuCompDir).append(str);
                    }
                    dirList.add(dir.toString());
                }
                while ((fileName = this.readString(data)).length() != 0) {
                    long leb128 = this.read_unsigned_leb128(data);
                    this.addSourceFile((String)dirList.get((int)leb128), fileName);
                    leb128 = this.read_unsigned_leb128(data);
                    leb128 = this.read_unsigned_leb128(data);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void getSourceFilesFromDebugLineSection() {
        int minHeaderSize;
        ByteBuffer data = (ByteBuffer)this.dwarfSections.get(".debug_line");
        if (data == null) {
            return;
        }
        int sectionSize = data.capacity();
        if (this.m_parsedLineTableSize >= sectionSize - (minHeaderSize = 16)) {
            return;
        }
        int lineTableStart = 0;
        try {
            while (lineTableStart < sectionSize - minHeaderSize) {
                String fileName;
                String str;
                data.position(lineTableStart);
                Integer currLineTableStart = new Integer(lineTableStart);
                int tableLength = this.read_4_bytes(data);
                if ((lineTableStart += tableLength + 4) < sectionSize - minHeaderSize && (lineTableStart & 3) != 0) {
                    boolean dataValid;
                    int savedPosition = data.position();
                    data.position(lineTableStart);
                    int ltLength = this.read_4_bytes(data);
                    short dwarfVer = this.read_2_bytes(data);
                    byte minInstLengh = data.get(data.position() + 4);
                    boolean bl = dataValid = ltLength > minHeaderSize && ltLength < 0x100000 && dwarfVer > 0 && dwarfVer < 4 && minInstLengh > 0 && minInstLengh <= 8;
                    if (!dataValid) {
                        lineTableStart = lineTableStart + 3 & 0xFFFFFFFC;
                    }
                    data.position(savedPosition);
                }
                if (this.m_parsedLineTableOffsets.contains(currLineTableStart)) continue;
                data.position(data.position() + 10);
                byte opcode_base = data.get();
                data.position(data.position() + opcode_base - 1);
                ArrayList<String> dirList = new ArrayList<String>();
                dirList.add("");
                while ((str = this.readString(data)).length() != 0) {
                    dirList.add(str);
                }
                while ((fileName = this.readString(data)).length() != 0) {
                    long leb128 = this.read_unsigned_leb128(data);
                    this.addSourceFile((String)dirList.get((int)leb128), fileName);
                    leb128 = this.read_unsigned_leb128(data);
                    leb128 = this.read_unsigned_leb128(data);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public String[] getSourceFiles() {
        if (!this.m_parsed) {
            this.m_fileCollection.clear();
            this.getSourceFilesFromDebugInfoSection();
            this.getSourceFilesFromDebugLineSection();
            this.m_parsed = true;
            this.m_fileNames = new String[this.m_fileCollection.size()];
            this.m_fileCollection.toArray(this.m_fileNames);
        }
        return this.m_fileNames;
    }

    private void getSourceFilesFromDebugInfoSection() {
        this.parse(null);
    }

    private void addSourceFile(String dir, String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (name.charAt(0) == '<') {
            return;
        }
        String fullName = name;
        Path dirPa = new Path(dir);
        Path pa = new Path(name);
        if (!pa.isAbsolute() && dir.length() > 0) {
            pa = dirPa.append((IPath)pa);
        }
        if (!this.m_fileCollection.contains(fullName = pa.toOSString())) {
            this.m_fileCollection.add(fullName);
        }
    }

    String readString(ByteBuffer data) {
        StringBuffer sb = new StringBuffer();
        while (data.hasRemaining()) {
            byte c = data.get();
            if (c == 0) break;
            sb.append((char)c);
        }
        String str = sb.toString();
        return str;
    }

    @Override
    void processDebugInfoEntry(IDebugEntryRequestor requestor, Dwarf.AbbreviationEntry entry, List<Dwarf.AttributeValue> list) {
        int tag = (int)entry.tag;
        switch (tag) {
            case 17: {
                this.processCompileUnit(requestor, list);
                break;
            }
        }
    }

    @Override
    void processCompileUnit(IDebugEntryRequestor requestor, List<Dwarf.AttributeValue> list) {
        int stmtList = -1;
        String cuCompDir = "";
        String cuName = "";
        int i = 0;
        while (i < list.size()) {
            Dwarf.AttributeValue av = list.get(i);
            try {
                int name = (int)av.attribute.name;
                switch (name) {
                    case 3: {
                        cuName = (String)av.value;
                        break;
                    }
                    case 27: {
                        cuCompDir = (String)av.value;
                        break;
                    }
                    case 16: {
                        stmtList = ((Number)av.value).intValue();
                        break;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        this.addSourceFile(cuCompDir, cuName);
        if (stmtList > -1) {
            this.parseSourceInCULineInfo(cuCompDir, stmtList);
        }
    }

    @Override
    public String[] getSourceFiles(IProgressMonitor monitor) {
        return this.getSourceFiles();
    }
}

