/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionExitNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CFACheck {
    private static final Function<CFANode, String> DEBUG_FORMAT = new Function<CFANode, String>(){

        public String apply(CFANode arg0) {
            return arg0.getFunctionName() + ":" + arg0.toString() + " (line " + arg0.getLineNumber() + ")";
        }
    };

    public static boolean check(CFAFunctionDefinitionNode cfa, Collection<CFANode> nodes) {
        HashSet<CFANode> visitedNodes = new HashSet<CFANode>();
        ArrayDeque<CFANode> waitingNodeList = new ArrayDeque<CFANode>();
        waitingNodeList.add(cfa);
        while (!waitingNodeList.isEmpty()) {
            CFANode node = (CFANode)waitingNodeList.poll();
            if (!visitedNodes.add(node)) continue;
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                waitingNodeList.add(edge.getSuccessor());
            }
            CFACheck.isConsistent(node);
            CFACheck.checkEdgeCount(node);
        }
        if (nodes != null && !((Object)visitedNodes).equals(nodes)) assert (false) : "\nNodes in CFA but not reachable through traversal: " + Iterables.transform((Iterable)Sets.difference(new HashSet<CFANode>(nodes), visitedNodes), DEBUG_FORMAT) + "\nNodes reached that are not in CFA: " + Iterables.transform((Iterable)Sets.difference(visitedNodes, new HashSet<CFANode>(nodes)), DEBUG_FORMAT);
        return true;
    }

    private static void checkEdgeCount(CFANode pNode) {
        int entering = pNode.getNumEnteringEdges();
        if (entering == 0) assert (pNode instanceof CFAFunctionDefinitionNode) : "Dead code: node " + (String)DEBUG_FORMAT.apply((Object)pNode) + " has no incoming edges";
        if (!(pNode instanceof CFAFunctionExitNode)) {
            switch (pNode.getNumLeavingEdges()) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    CFAEdge edge1 = pNode.getLeavingEdge(0);
                    CFAEdge edge2 = pNode.getLeavingEdge(1);
                    assert (edge1 instanceof AssumeEdge && edge2 instanceof AssumeEdge) : "Branching without conditions at node " + (String)DEBUG_FORMAT.apply((Object)pNode);
                    AssumeEdge ae1 = (AssumeEdge)edge1;
                    AssumeEdge ae2 = (AssumeEdge)edge2;
                    assert (ae1.getTruthAssumption() != ae2.getTruthAssumption()) : "Inconsistent branching at node " + (String)DEBUG_FORMAT.apply((Object)pNode);
                    break;
                }
                default: {
                    assert (false) : "Too much branching at node " + (String)DEBUG_FORMAT.apply((Object)pNode);
                    break;
                }
            }
        }
    }

    private static void isConsistent(CFANode pNode) {
        boolean hasEdge;
        HashSet<CFAEdge> seenEdges = new HashSet<CFAEdge>();
        HashSet<CFANode> seenNodes = new HashSet<CFANode>();
        for (CFAEdge edge : CFAUtils.leavingEdges(pNode)) {
            if (!seenEdges.add(edge)) assert (false) : "Duplicate leaving edge " + edge + " on node " + (String)DEBUG_FORMAT.apply((Object)pNode);
            CFANode successor = edge.getSuccessor();
            if (!seenNodes.add(successor)) assert (false) : "Duplicate successor " + successor + " for node " + (String)DEBUG_FORMAT.apply((Object)pNode);
            hasEdge = Iterables.contains(CFAUtils.enteringEdges(successor), (Object)edge);
            assert (hasEdge) : "Node " + (String)DEBUG_FORMAT.apply((Object)pNode) + " has leaving edge " + edge + ", but pNode " + (String)DEBUG_FORMAT.apply((Object)pNode) + " does not have this edge as entering edge!";
        }
        seenEdges.clear();
        seenNodes.clear();
        for (CFAEdge edge : CFAUtils.enteringEdges(pNode)) {
            if (!seenEdges.add(edge)) assert (false) : "Duplicate entering edge " + edge + " on node " + (String)DEBUG_FORMAT.apply((Object)pNode);
            CFANode predecessor = edge.getPredecessor();
            if (!seenNodes.add(predecessor)) assert (false) : "Duplicate predecessor " + predecessor + " for node " + (String)DEBUG_FORMAT.apply((Object)pNode);
            hasEdge = Iterables.contains(CFAUtils.leavingEdges(predecessor), (Object)edge);
            assert (hasEdge) : "Node " + (String)DEBUG_FORMAT.apply((Object)pNode) + " has entering edge " + edge + ", but pNode " + (String)DEBUG_FORMAT.apply((Object)pNode) + " does not have this edge as leaving edge!";
        }
    }
}

