/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;

public class CFACreationUtils {
    public static void addEdgeToCFA(CFAEdge edge, LogManager logger) {
        CFANode predecessor = edge.getPredecessor();
        if (edge instanceof AssumeEdge) {
            assert (predecessor.getNumLeavingEdges() <= 1);
            if (predecessor.getNumLeavingEdges() > 0) assert (predecessor.getLeavingEdge(0) instanceof AssumeEdge);
        } else assert (predecessor.getNumLeavingEdges() == 0);
        if (CFACreationUtils.isReachableNode(predecessor) || edge instanceof StatementEdge && edge.getSuccessor().isLoopStart()) {
            edge.getPredecessor().addLeavingEdge(edge);
            edge.getSuccessor().addEnteringEdge(edge);
        } else if (!edge.getDescription().isEmpty()) {
            Level level = Level.INFO;
            if (edge.getDescription().matches("^Goto: (switch|while)_\\d+_[a-z0-9]+$")) {
                level = Level.FINER;
            }
            logger.log(level, new Object[]{"Dead code detected at line", edge.getLineNumber() + ":", edge.getRawStatement()});
        }
    }

    public static boolean isReachableNode(CFANode node) {
        return node.getNumEnteringEdges() > 0 || node instanceof CFAFunctionDefinitionNode || node.isLoopStart() || node instanceof CFALabelNode && !((CFALabelNode)node).getLabel().isEmpty();
    }

    public static void removeChainOfNodesFromCFA(CFANode n) {
        if (n.getNumEnteringEdges() > 0) {
            return;
        }
        for (int i = n.getNumLeavingEdges() - 1; i >= 0; --i) {
            CFAEdge e = n.getLeavingEdge(i);
            CFANode succ = e.getSuccessor();
            CFACreationUtils.removeEdgeFromNodes(e);
            CFACreationUtils.removeChainOfNodesFromCFA(succ);
        }
    }

    public static void removeEdgeFromNodes(CFAEdge e) {
        e.getPredecessor().removeLeavingEdge(e);
        e.getSuccessor().removeEnteringEdge(e);
    }

    public static void removeSummaryEdgeFromNodes(CallToReturnEdge e) {
        e.getPredecessor().removeLeavingSummaryEdge(e);
        e.getSuccessor().removeEnteringSummaryEdge(e);
    }
}

