/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.Level;
import org.sosy_lab.common.Files;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACheck;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.CFAReduction;
import org.sosy_lab.cpachecker.cfa.CFASecondPassBuilder;
import org.sosy_lab.cpachecker.cfa.CFATopologicalSort;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.DOTBuilder;
import org.sosy_lab.cpachecker.cfa.DOTBuilder2;
import org.sosy_lab.cpachecker.cfa.ImmutableCFA;
import org.sosy_lab.cpachecker.cfa.MultiEdgeCreator;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.objectmodel.BlankEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.CFAUtils;

@Options
public class CFACreator {
    @Option(name="analysis.entryFunction", regexp="^[_a-zA-Z][_a-zA-Z0-9]*$", description="entry function")
    private String mainFunctionName = "main";
    @Option(name="analysis.interprocedural", description="run interprocedural analysis")
    private boolean interprocedural = true;
    @Option(name="analysis.useGlobalVars", description="add declarations for global variables before entry function")
    private boolean useGlobalVars = true;
    @Option(name="cfa.useMultiEdges", description="combine sequences of simple edges into a single edge")
    private boolean useMultiEdges = false;
    @Option(name="cfa.removeIrrelevantForErrorLocations", description="remove paths from CFA that cannot lead to a error location")
    private boolean removeIrrelevantForErrorLocations = false;
    @Option(name="cfa.export", description="export CFA as .dot file")
    private boolean exportCfa = true;
    @Option(name="cfa.exportPerFunction", description="export individual CFAs for function as .dot files")
    private boolean exportCfaPerFunction = true;
    @Option(name="cfa.file", description="export CFA as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private File exportCfaFile = new File("cfa.dot");
    private final LogManager logger;
    private final CParser parser;
    private final CFAReduction cfaReduction;
    public final Timer parserInstantiationTime = new Timer();
    public final Timer totalTime = new Timer();
    public final Timer parsingTime;
    public final Timer conversionTime;
    public final Timer checkTime = new Timer();
    public final Timer processingTime = new Timer();
    public final Timer pruningTime = new Timer();
    public final Timer exportTime = new Timer();

    public CFACreator(Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = logger;
        this.parserInstantiationTime.start();
        this.parser = CParser.Factory.getParser(logger, CParser.Factory.getOptions(config));
        this.parsingTime = this.parser.getParseTime();
        this.conversionTime = this.parser.getCFAConstructionTime();
        this.cfaReduction = this.removeIrrelevantForErrorLocations ? new CFAReduction(config, logger) : null;
        this.parserInstantiationTime.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFA parseFileAndCreateCFA(String filename) throws InvalidConfigurationException, IOException, ParserException, InterruptedException {
        this.totalTime.start();
        try {
            Object spbuilder;
            this.logger.log(Level.FINE, new Object[]{"Starting parsing of file"});
            ParseResult c = this.parser.parseFile(filename);
            this.logger.log(Level.FINE, new Object[]{"Parser Finished"});
            if (c.isEmpty()) {
                throw new ParserException("No functions found in program");
            }
            CFAFunctionDefinitionNode mainFunction = this.getMainFunction(filename, c.getFunctions());
            MutableCFA cfa = new MutableCFA(c.getFunctions(), c.getCFANodes(), mainFunction);
            this.checkTime.start();
            for (String functionName : cfa.getAllFunctionNames()) {
                assert (CFACheck.check(cfa.getFunctionHead(functionName), cfa.getFunctionNodes(functionName)));
            }
            this.checkTime.stop();
            this.processingTime.start();
            for (CFAFunctionDefinitionNode function : cfa.getAllFunctionHeads()) {
                CFATopologicalSort topSort = new CFATopologicalSort();
                topSort.topologicalSort(function);
            }
            Optional<ImmutableMultimap<String, CFAUtils.Loop>> loopStructure = this.getLoopStructure(cfa);
            if (this.interprocedural) {
                this.logger.log(Level.FINE, new Object[]{"Analysis is interprocedural, adding super edges."});
                spbuilder = new CFASecondPassBuilder(cfa.getAllFunctions());
                ((CFASecondPassBuilder)spbuilder).insertCallEdgesRecursively();
            }
            if (this.useGlobalVars) {
                CFACreator.insertGlobalDeclarations(cfa, c.getGlobalDeclarations());
            }
            this.processingTime.stop();
            if (this.cfaReduction != null) {
                this.pruningTime.start();
                this.cfaReduction.removeIrrelevantForErrorLocations(cfa);
                this.pruningTime.stop();
                if (cfa.isEmpty()) {
                    this.logger.log(Level.INFO, new Object[]{"No error locations reachable from " + mainFunction.getFunctionName() + ", analysis not necessary. " + "If the code contains no error location named ERROR, set the option cfa.removeIrrelevantForErrorLocations to false."});
                    spbuilder = ImmutableCFA.empty();
                    return spbuilder;
                }
            }
            if (this.useMultiEdges) {
                MultiEdgeCreator.createMultiEdges(cfa);
            }
            ImmutableCFA immutableCFA = cfa.makeImmutableCFA(loopStructure);
            this.checkTime.start();
            assert (CFACheck.check(mainFunction, null));
            this.checkTime.stop();
            if (this.exportCfaFile != null && (this.exportCfa || this.exportCfaPerFunction)) {
                this.exportCFA(immutableCFA);
            }
            this.logger.log(Level.FINE, new Object[]{"DONE, CFA for", immutableCFA.getNumberOfFunctions(), "functions created."});
            ImmutableCFA immutableCFA2 = immutableCFA;
            return immutableCFA2;
        }
        finally {
            this.totalTime.stop();
        }
    }

    private CFAFunctionDefinitionNode getMainFunction(String filename, Map<String, CFAFunctionDefinitionNode> cfas) throws InvalidConfigurationException {
        CFAFunctionDefinitionNode mainFunction = cfas.get(this.mainFunctionName);
        if (mainFunction != null) {
            return mainFunction;
        }
        if (!this.mainFunctionName.equals("main")) {
            throw new InvalidConfigurationException("Function " + this.mainFunctionName + " not found.");
        }
        if (cfas.size() == 1) {
            return (CFAFunctionDefinitionNode)Iterables.getOnlyElement(cfas.values());
        }
        int indexOfDot = (filename = new File(filename).getName()).indexOf(46);
        String baseFilename = indexOfDot >= 1 ? filename.substring(0, indexOfDot) : filename;
        mainFunction = cfas.get(baseFilename);
        if (mainFunction == null) {
            throw new InvalidConfigurationException("No entry function found, please specify one.");
        }
        return mainFunction;
    }

    private Optional<ImmutableMultimap<String, CFAUtils.Loop>> getLoopStructure(MutableCFA cfa) {
        try {
            ImmutableMultimap.Builder loops = ImmutableMultimap.builder();
            for (String functionName : cfa.getAllFunctionNames()) {
                SortedSet<CFANode> nodes = cfa.getFunctionNodes(functionName);
                loops.putAll((Object)functionName, CFAUtils.findLoops(nodes));
            }
            return Optional.of((Object)loops.build());
        }
        catch (ParserException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not analyze loop structure of program.");
        }
        catch (OutOfMemoryError e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not analyze loop structure of program due to memory problems");
        }
        return Optional.absent();
    }

    public static void insertGlobalDeclarations(MutableCFA cfa, List<Pair<IASTDeclaration, String>> globalVars) {
        if (globalVars.isEmpty()) {
            return;
        }
        CFAFunctionDefinitionNode firstNode = cfa.getMainFunction();
        assert (firstNode.getNumLeavingEdges() == 1);
        CFAEdge firstEdge = firstNode.getLeavingEdge(0);
        assert (firstEdge instanceof BlankEdge);
        CFANode secondNode = firstEdge.getSuccessor();
        CFACreationUtils.removeEdgeFromNodes(firstEdge);
        CFANode cur = new CFANode(0, firstNode.getFunctionName());
        cfa.addNode(cur);
        BlankEdge be = new BlankEdge("", 0, firstNode, cur, "INIT GLOBAL VARS");
        CFACreator.addToCFA(be);
        for (Pair<IASTDeclaration, String> p : globalVars) {
            IASTDeclaration d = (IASTDeclaration)p.getFirst();
            String rawSignature = (String)p.getSecond();
            assert (d.isGlobal());
            CFANode n = new CFANode(d.getFileLocation().getStartingLineNumber(), cur.getFunctionName());
            cfa.addNode(n);
            DeclarationEdge e = new DeclarationEdge(rawSignature, d.getFileLocation().getStartingLineNumber(), cur, n, d);
            CFACreator.addToCFA(e);
            cur = n;
        }
        be = new BlankEdge(firstEdge.getRawStatement(), firstEdge.getLineNumber(), cur, secondNode, firstEdge.getDescription());
        CFACreator.addToCFA(be);
    }

    private void exportCFA(CFA cfa) {
        this.exportTime.start();
        if (this.exportCfa) {
            try {
                Files.writeFile((File)this.exportCfaFile, (Object)DOTBuilder.generateDOT(cfa.getAllFunctionHeads(), cfa.getMainFunction()));
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write CFA to dot file.");
            }
        }
        if (this.exportCfaPerFunction) {
            try {
                File outdir = this.exportCfaFile.getParentFile();
                DOTBuilder2.writeReport(cfa, outdir);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write CFA to dot and json file.");
            }
        }
        this.exportTime.stop();
    }

    private static void addToCFA(CFAEdge edge) {
        edge.getPredecessor().addLeavingEdge(edge);
        edge.getSuccessor().addEnteringEdge(edge);
    }
}

