/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.CFATraversal;

@Options(prefix="cfa.pruning")
public class CFAReduction {
    private final Configuration config;
    private final LogManager logger;

    public CFAReduction(Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        if (config.getProperty("specification") == null) {
            throw new InvalidConfigurationException("Option cfa.removeIrrelevantForErrorLocations is only valid if a specification is given!");
        }
        this.config = config;
        this.logger = logger;
    }

    public void removeIrrelevantForErrorLocations(MutableCFA cfa) throws InterruptedException {
        Collection<CFANode> errorNodes = this.getErrorNodesWithCPA(cfa);
        if (errorNodes.isEmpty()) {
            cfa.clear();
            return;
        }
        Collection<CFANode> allNodes = cfa.getAllNodes();
        if (errorNodes.size() == allNodes.size()) {
            return;
        }
        CFATraversal.NodeCollectingCFAVisitor cfaVisitor = new CFATraversal.NodeCollectingCFAVisitor();
        CFATraversal traversal = CFATraversal.dfs().backwards();
        for (CFANode n : errorNodes) {
            traversal.traverse(n, cfaVisitor);
        }
        Set<CFANode> relevantNodes = cfaVisitor.getVisitedNodes();
        assert (allNodes.containsAll(relevantNodes)) : "Inconsistent CFA";
        int numIrrelevantNodes = allNodes.size() - relevantNodes.size();
        this.logger.log(Level.INFO, new Object[]{"Detected", numIrrelevantNodes, "irrelevant CFA nodes."});
        if (numIrrelevantNodes == 0) {
            return;
        }
        Predicate irrelevantNode = Predicates.not((Predicate)Predicates.in(relevantNodes));
        ImmutableList removedNodes = ImmutableList.copyOf((Collection)Collections2.filter(allNodes, (Predicate)irrelevantNode));
        this.pruneIrrelevantNodes(cfa, (Collection<CFANode>)removedNodes, errorNodes);
    }

    private Collection<CFANode> getErrorNodesWithCPA(MutableCFA cfa) throws InterruptedException {
        try {
            ReachedSetFactory lReachedSetFactory = new ReachedSetFactory(Configuration.defaultConfiguration(), this.logger);
            Configuration lConfig = Configuration.builder().copyFrom(this.config).setOption("output.disable", "true").clearOption("cpa").clearOption("cpas").clearOption("CompositeCPA.cpas").build();
            CPABuilder lBuilder = new CPABuilder(lConfig, this.logger, lReachedSetFactory);
            ConfigurableProgramAnalysis lCpas = lBuilder.buildCPAs(cfa);
            CPAAlgorithm lAlgorithm = new CPAAlgorithm(lCpas, this.logger);
            ReachedSet lReached = lReachedSetFactory.create();
            lReached.add(lCpas.getInitialElement(cfa.getMainFunction()), lCpas.getInitialPrecision(cfa.getMainFunction()));
            lAlgorithm.run(lReached);
            return ImmutableSet.copyOf(AbstractElements.extractLocations(AbstractElements.filterTargetElements(lReached)));
        }
        catch (CPAException e) {
            this.logger.log(Level.WARNING, new Object[]{"Error during CFA reduction, using full CFA"});
            this.logger.logDebugException((Throwable)e);
        }
        catch (InvalidConfigurationException e) {
            this.logger.log(Level.WARNING, new Object[]{"Error during CFA reduction, using full CFA"});
            this.logger.logDebugException((Throwable)e);
        }
        return cfa.getAllNodes();
    }

    private void pruneIrrelevantNodes(MutableCFA cfa, Collection<CFANode> irrelevantNodes, Collection<CFANode> errorNodes) {
        for (CFANode n : irrelevantNodes) {
            cfa.removeNode(n);
            for (int edgeIndex = n.getNumEnteringEdges() - 1; edgeIndex >= 0; --edgeIndex) {
                CFAEdge removedEdge = n.getEnteringEdge(edgeIndex);
                CFANode prevNode = removedEdge.getPredecessor();
                if (errorNodes.contains(prevNode)) continue;
                CFACreationUtils.removeEdgeFromNodes(removedEdge);
            }
            while (n.getNumLeavingEdges() > 0) {
                CFACreationUtils.removeEdgeFromNodes(n.getLeavingEdge(0));
            }
            if (n.getEnteringSummaryEdge() != null) {
                CFACreationUtils.removeSummaryEdgeFromNodes(n.getEnteringSummaryEdge());
            }
            if (n.getLeavingSummaryEdge() == null) continue;
            CFACreationUtils.removeSummaryEdgeFromNodes(n.getLeavingSummaryEdge());
        }
    }
}

