/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionExitNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CFASecondPassBuilder {
    private final Map<String, CFAFunctionDefinitionNode> cfas;

    public CFASecondPassBuilder(Map<String, CFAFunctionDefinitionNode> cfas) {
        this.cfas = cfas;
    }

    public void insertCallEdgesRecursively() throws ParserException {
        for (CFAFunctionDefinitionNode functionStartNode : this.cfas.values()) {
            this.insertCallEdges(functionStartNode);
        }
    }

    private void insertCallEdges(CFAFunctionDefinitionNode initialNode) throws ParserException {
        ArrayDeque<CFANode> workList = new ArrayDeque<CFANode>();
        HashSet<CFANode> processed = new HashSet<CFANode>();
        workList.addLast(initialNode);
        while (!workList.isEmpty()) {
            CFANode node = (CFANode)workList.pollFirst();
            if (!processed.add(node)) continue;
            for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                StatementEdge statement;
                IASTStatement expr;
                if (edge instanceof StatementEdge && this.shouldCreateCallEdges(expr = (statement = (StatementEdge)edge).getStatement())) {
                    this.createCallAndReturnEdges(statement, (IASTFunctionCall)((Object)expr));
                }
                CFANode successorNode = edge.getSuccessor();
                if (!node.getFunctionName().equals(successorNode.getFunctionName())) continue;
                workList.add(successorNode);
            }
        }
    }

    private boolean shouldCreateCallEdges(IASTStatement s) {
        if (!(s instanceof IASTFunctionCall)) {
            return false;
        }
        IASTFunctionCallExpression f = ((IASTFunctionCall)((Object)s)).getFunctionCallExpression();
        String name = f.getFunctionNameExpression().toASTString();
        return this.cfas.containsKey(name);
    }

    private void createCallAndReturnEdges(StatementEdge edge, IASTFunctionCall functionCall) throws ParserException {
        CFANode predecessorNode = edge.getPredecessor();
        CFANode successorNode = edge.getSuccessor();
        IASTFunctionCallExpression functionCallExpression = functionCall.getFunctionCallExpression();
        String functionName = functionCallExpression.getFunctionNameExpression().toASTString();
        int lineNumber = edge.getLineNumber();
        CFAFunctionDefinitionNode fDefNode = this.cfas.get(functionName);
        CFAFunctionExitNode fExitNode = fDefNode.getExitNode();
        assert (fDefNode instanceof FunctionDefinitionNode) : "This code creates edges from package cfa.objectmodel.c, so the nodes need to be from this package, too.";
        List<IASTExpression> parameters = functionCallExpression.getParameterExpressions();
        IASTFunctionTypeSpecifier functionType = ((FunctionDefinitionNode)fDefNode).getFunctionDefinition().getDeclSpecifier();
        int declaredParameters = functionType.getParameters().size();
        int actualParameters = parameters.size();
        if (!functionType.takesVarArgs() && declaredParameters != actualParameters) {
            throw new ParserException("Function " + functionName + " takes " + declaredParameters + " parameter(s) but is called with " + actualParameters + " parameter(s)", edge);
        }
        CFACreationUtils.removeEdgeFromNodes(edge);
        CallToReturnEdge calltoReturnEdge = new CallToReturnEdge(edge.getRawStatement(), lineNumber, predecessorNode, successorNode, functionCall);
        predecessorNode.addLeavingSummaryEdge(calltoReturnEdge);
        successorNode.addEnteringSummaryEdge(calltoReturnEdge);
        FunctionCallEdge callEdge = new FunctionCallEdge(edge.getRawStatement(), lineNumber, predecessorNode, (FunctionDefinitionNode)fDefNode, functionCall, calltoReturnEdge);
        predecessorNode.addLeavingEdge(callEdge);
        fDefNode.addEnteringEdge(callEdge);
        if (fExitNode.getNumEnteringEdges() == 0) {
            CFACreationUtils.removeChainOfNodesFromCFA(successorNode);
        } else {
            FunctionReturnEdge returnEdge = new FunctionReturnEdge(lineNumber, fExitNode, successorNode, calltoReturnEdge);
            fExitNode.addLeavingEdge(returnEdge);
            successorNode.addEnteringEdge(returnEdge);
        }
    }
}

