/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.io.IOException;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.EclipseCDT6Parser;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.EclipseCDT7Parser;
import org.sosy_lab.cpachecker.exceptions.ParserException;

public interface CParser {
    public ParseResult parseFile(String var1) throws ParserException, IOException;

    public ParseResult parseString(String var1) throws ParserException;

    public IASTNode parseSingleStatement(String var1) throws ParserException;

    public Timer getParseTime();

    public Timer getCFAConstructionTime();

    public static class Factory {
        private static boolean IS_CDT_7 = Factory.isCDT7();

        public static ParserOptions getOptions(Configuration config) throws InvalidConfigurationException {
            ParserOptions result = new ParserOptions();
            config.inject((Object)result);
            return result;
        }

        public static ParserOptions getDefaultOptions() {
            return new ParserOptions();
        }

        public static CParser getParser(LogManager logger, ParserOptions options) {
            EclipseCDT7Parser result = IS_CDT_7 ? new EclipseCDT7Parser(logger, options.dialect) : new EclipseCDT6Parser(logger, options.dialect);
            result.setIgnoreCasts(options.ignoreCasts);
            return result;
        }

        private static boolean isCDT7() {
            try {
                Class.forName("org.eclipse.cdt.core.parser.IncludeFileContentProvider");
                return true;
            }
            catch (ClassNotFoundException _) {
                return false;
            }
        }
    }

    @Options(prefix="parser")
    public static final class ParserOptions {
        @Option(description="C dialect for parser")
        private Dialect dialect = Dialect.GNUC;
        @Option(description="Ignore all casts that appear in the source code.")
        private boolean ignoreCasts = false;

        private ParserOptions() {
        }
    }

    public static enum Dialect {
        C99,
        GNUC;

    }
}

