/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;

public final class DOTBuilder {
    private static final String MAIN_GRAPH = "____Main____Diagram__";
    private static final Joiner JOINER_ON_NEWLINE = Joiner.on((char)'\n');

    private DOTBuilder() {
    }

    public static String generateDOT(Collection<CFAFunctionDefinitionNode> cfasMapList, CFAFunctionDefinitionNode cfa) {
        DotGenerator dotGenerator = new DotGenerator();
        CFATraversal.dfs().traverse(cfa, new CFATraversal.NodeCollectingCFAVisitor(dotGenerator));
        StringBuilder sb = new StringBuilder();
        sb.append("digraph CFA {\n");
        JOINER_ON_NEWLINE.appendTo(sb, (Iterable)dotGenerator.nodes);
        sb.append('\n');
        sb.append("node [shape=\"circle\"]\n");
        for (CFAFunctionDefinitionNode fnode : cfasMapList) {
            sb.append("subgraph cluster_" + fnode.getFunctionName() + " {\n");
            sb.append("label=\"" + fnode.getFunctionName() + "()\"\n");
            JOINER_ON_NEWLINE.appendTo(sb, (Iterable)dotGenerator.edges.get((Object)fnode.getFunctionName()));
            sb.append("}\n");
        }
        JOINER_ON_NEWLINE.appendTo(sb, (Iterable)dotGenerator.edges.get((Object)MAIN_GRAPH));
        sb.append("}");
        return sb.toString();
    }

    private static class DotGenerator
    implements CFATraversal.CFAVisitor {
        private final List<String> nodes = new ArrayList<String>();
        private final ListMultimap<String, String> edges = ArrayListMultimap.create();

        private DotGenerator() {
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge edge) {
            CFANode predecessor = edge.getPredecessor();
            if (!predecessor.isLoopStart() && edge instanceof AssumeEdge) {
                this.nodes.add(DotGenerator.formatNode(predecessor, "diamond"));
            }
            List graph = edge instanceof FunctionCallEdge || edge instanceof FunctionReturnEdge ? this.edges.get((Object)DOTBuilder.MAIN_GRAPH) : this.edges.get((Object)predecessor.getFunctionName());
            graph.add(DotGenerator.formatEdge(edge));
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode node) {
            if (node.isLoopStart()) {
                this.nodes.add(DotGenerator.formatNode(node, "doublecircle"));
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        private static String formatNode(CFANode node, String shape) {
            return node.getNodeNumber() + " [shape=\"" + shape + "\"]";
        }

        private static String formatEdge(CFAEdge edge) {
            StringBuilder sb = new StringBuilder();
            sb.append(edge.getPredecessor().getNodeNumber());
            sb.append(" -> ");
            sb.append(edge.getSuccessor().getNodeNumber());
            sb.append(" [label=\"");
            sb.append(edge.getDescription().replaceAll("\\Q\\\"\\E", "\\ \"").replaceAll("\\\"", "\\\\\\\"").replaceAll("\n", " "));
            sb.append("\"");
            if (edge instanceof CallToReturnEdge) {
                sb.append(" style=\"dotted\" arrowhead=\"empty\"");
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

