/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import org.json.simple.JSONObject;
import org.sosy_lab.common.Files;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;

public final class DOTBuilder2 {
    private DOTBuilder2() {
    }

    public static void writeReport(CFA cfa, File outdir) throws IOException {
        CFAJSONBuilder jsoner = new CFAJSONBuilder();
        DOTViewBuilder dotter = new DOTViewBuilder();
        CFATraversal.NodeCollectingCFAVisitor vis = new CFATraversal.NodeCollectingCFAVisitor(new CFATraversal.CompositeCFAVisitor(jsoner, dotter));
        for (CFAFunctionDefinitionNode entryNode : cfa.getAllFunctionHeads()) {
            CFATraversal.dfs().ignoreFunctionCalls().traverse(entryNode, vis);
            dotter.writeFunctionFile(entryNode.getFunctionName(), outdir);
        }
        dotter.writeGlobalFiles(outdir);
        Files.writeFile((File)new File(outdir, "cfainfo.json"), (Object)jsoner.getJSON().toJSONString());
    }

    private static String getEdgeText(CFAEdge edge) {
        return edge.getDescription().replaceAll("\\Q\\\"\\E", "\\ \"").replaceAll("\\\"", "\\\\\\\"").replaceAll("\n", " ").replaceAll("\\s+", " ").replaceAll(" ;", ";");
    }

    private static class CFAJSONBuilder
    extends CFATraversal.DefaultCFAVisitor {
        private final JSONObject nodes = new JSONObject();
        private final JSONObject edges = new JSONObject();

        private CFAJSONBuilder() {
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode node) {
            JSONObject jnode = new JSONObject();
            jnode.put((Object)"no", (Object)node.getNodeNumber());
            jnode.put((Object)"line", (Object)node.getLineNumber());
            jnode.put((Object)"func", (Object)node.getFunctionName());
            this.nodes.put((Object)node.getNodeNumber(), (Object)jnode);
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge edge) {
            JSONObject jedge = new JSONObject();
            int src = edge.getPredecessor().getNodeNumber();
            int target = edge.getSuccessor().getNodeNumber();
            jedge.put((Object)"line", (Object)edge.getLineNumber());
            jedge.put((Object)"source", (Object)src);
            jedge.put((Object)"target", (Object)target);
            jedge.put((Object)"stmt", (Object)DOTBuilder2.getEdgeText(edge));
            jedge.put((Object)"type", (Object)edge.getEdgeType().toString());
            this.edges.put((Object)("" + src + "->" + target), (Object)jedge);
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        JSONObject getJSON() {
            JSONObject obj = new JSONObject();
            obj.put((Object)"nodes", (Object)this.nodes);
            obj.put((Object)"edges", (Object)this.edges);
            return obj;
        }
    }

    private static class DOTViewBuilder
    extends CFATraversal.DefaultCFAVisitor {
        private final JSONObject node2combo = new JSONObject();
        private final JSONObject virtFuncCallEdges = new JSONObject();
        private int virtFuncCallNodeIdCounter = 100000;
        private final Set<CFANode> nodes = Sets.newLinkedHashSet();
        private final List<CFAEdge> edges = Lists.newArrayList();
        private final List<List<CFAEdge>> comboedges = Lists.newArrayList();
        private List<CFAEdge> currentComboEdge = null;

        private DOTViewBuilder() {
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge edge) {
            CFANode predecessor = edge.getPredecessor();
            if (predecessor.isLoopStart() || predecessor.getNumEnteringEdges() != 1 || predecessor.getNumLeavingEdges() != 1 || this.currentComboEdge != null && !predecessor.equals(this.currentComboEdge.get(this.currentComboEdge.size() - 1).getSuccessor()) || edge instanceof CallToReturnEdge || edge instanceof AssumeEdge) {
                this.edges.add(edge);
                this.currentComboEdge = null;
                this.nodes.add(predecessor);
                this.nodes.add(edge.getSuccessor());
            } else {
                if (this.currentComboEdge == null) {
                    this.currentComboEdge = Lists.newArrayList();
                    this.comboedges.add(this.currentComboEdge);
                }
                this.currentComboEdge.add(edge);
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeFunctionFile(String funcname, File outdir) throws IOException {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outdir, "cfa__" + funcname + ".dot")), "UTF-8");
            try {
                out.write("digraph " + funcname + " {\n");
                StringBuilder outb = new StringBuilder();
                for (List<CFAEdge> combo : this.comboedges) {
                    if (combo.size() == 1) {
                        this.edges.add(combo.get(0));
                        this.nodes.add(combo.get(0).getPredecessor());
                        this.nodes.add(combo.get(0).getSuccessor());
                        continue;
                    }
                    outb.append(this.comboToDot(combo));
                    CFAEdge first = combo.get(0);
                    CFAEdge last = combo.get(combo.size() - 1);
                    outb.append(first.getPredecessor().getNodeNumber());
                    outb.append(" -> ");
                    outb.append(last.getSuccessor().getNodeNumber());
                    outb.append("[label=\"\"]\n");
                }
                for (CFANode node : this.nodes) {
                    out.write(DOTViewBuilder.nodeToDot(node));
                }
                out.write(outb.toString());
                for (CFAEdge edge : this.edges) {
                    out.write(this.edgeToDot(edge));
                }
                out.write("}");
                this.nodes.clear();
                this.edges.clear();
                this.comboedges.clear();
            }
            finally {
                ((Writer)out).close();
            }
        }

        void writeGlobalFiles(File outdir) throws IOException {
            Files.writeFile((File)new File(outdir, "combinednodes.json"), (Object)this.node2combo.toJSONString());
            Files.writeFile((File)new File(outdir, "fcalledges.json"), (Object)this.virtFuncCallEdges.toJSONString());
        }

        private static String nodeToDot(CFANode node) {
            String shape = "circle";
            if (node.isLoopStart()) {
                shape = "doublecircle";
            } else if (node.getNumLeavingEdges() > 0 && node.getLeavingEdge(0) instanceof AssumeEdge) {
                shape = "diamond";
            }
            return node.getNodeNumber() + " [shape=\"" + shape + "\"]\n";
        }

        private String edgeToDot(CFAEdge edge) {
            if (edge instanceof CallToReturnEdge) {
                String calledFunction = edge.getPredecessor().getLeavingEdge(0).getSuccessor().getFunctionName();
                String ret = ++this.virtFuncCallNodeIdCounter + " [shape=\"component\" label=\"" + calledFunction + "\"]\n";
                int from = edge.getPredecessor().getNodeNumber();
                ret = ret + String.format("%d -> %d [label=\"%s\" fontname=\"Courier New\"]%n", from, this.virtFuncCallNodeIdCounter, DOTBuilder2.getEdgeText(edge));
                int to = edge.getSuccessor().getNodeNumber();
                ret = ret + String.format("%d -> %d [label=\"\" fontname=\"Courier New\"]%n", this.virtFuncCallNodeIdCounter, to);
                this.virtFuncCallEdges.put((Object)from, (Object)Lists.newArrayList((Object[])new Integer[]{this.virtFuncCallNodeIdCounter, to}));
                return ret;
            }
            return String.format("%d -> %d [label=\"%s\" fontname=\"Courier New\"]%n", edge.getPredecessor().getNodeNumber(), edge.getSuccessor().getNodeNumber(), DOTBuilder2.getEdgeText(edge));
        }

        private String comboToDot(List<CFAEdge> combo) {
            CFAEdge first = combo.get(0);
            StringBuilder sb = new StringBuilder();
            int firstNo = first.getPredecessor().getNodeNumber();
            sb.append(firstNo);
            sb.append(" [style=\"filled,bold\" penwidth=\"1\" fillcolor=\"white\" fontname=\"Courier New\" shape=\"Mrecord\" label=");
            if (combo.size() > 20) {
                CFAEdge last = combo.get(combo.size() - 1);
                int lastNo = last.getPredecessor().getNodeNumber();
                sb.append("\"Long linear chain of edges between nodes ");
                sb.append(firstNo);
                sb.append(" and ");
                sb.append(lastNo);
                sb.append('\"');
            } else {
                sb.append("<<table border=\"0\" cellborder=\"0\" cellpadding=\"3\" bgcolor=\"white\">");
                for (CFAEdge edge : combo) {
                    sb.append("<tr><td align=\"right\">");
                    sb.append("" + edge.getPredecessor().getNodeNumber());
                    sb.append("</td><td align=\"left\">");
                    sb.append("" + DOTBuilder2.getEdgeText(edge).replaceAll("\\|", "&#124;").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\\{", "&#123;").replaceAll("\\}", "&#125;"));
                    sb.append("</td></tr>");
                }
                sb.append("</table>>");
            }
            for (CFAEdge edge : combo) {
                this.node2combo.put((Object)edge.getPredecessor().getNodeNumber(), (Object)firstNo);
            }
            sb.append("]\n");
            return sb.toString();
        }
    }
}

