/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.util.CFAUtils;

class ImmutableCFA
implements CFA {
    private final ImmutableMap<String, CFAFunctionDefinitionNode> functions;
    private final ImmutableSortedSet<CFANode> allNodes;
    private final CFAFunctionDefinitionNode mainFunction;
    private final Optional<ImmutableMultimap<String, CFAUtils.Loop>> loopStructure;

    ImmutableCFA(Map<String, CFAFunctionDefinitionNode> pFunctions, SetMultimap<String, CFANode> pAllNodes, CFAFunctionDefinitionNode pMainFunction, Optional<ImmutableMultimap<String, CFAUtils.Loop>> pLoopStructure) {
        this.functions = ImmutableMap.copyOf(pFunctions);
        this.allNodes = ImmutableSortedSet.copyOf((Collection)pAllNodes.values());
        this.mainFunction = (CFAFunctionDefinitionNode)Preconditions.checkNotNull((Object)pMainFunction);
        this.loopStructure = pLoopStructure;
        Preconditions.checkArgument((this.functions.get((Object)this.mainFunction.getFunctionName()) == this.mainFunction ? 1 : 0) != 0);
    }

    private ImmutableCFA() {
        this.functions = ImmutableMap.of();
        this.allNodes = ImmutableSortedSet.of();
        this.mainFunction = null;
        this.loopStructure = Optional.absent();
    }

    static ImmutableCFA empty() {
        return new ImmutableCFA();
    }

    @Override
    public boolean isEmpty() {
        return this.functions.isEmpty();
    }

    @Override
    public int getNumberOfFunctions() {
        return this.functions.size();
    }

    public ImmutableSet<String> getAllFunctionNames() {
        return this.functions.keySet();
    }

    public ImmutableCollection<CFAFunctionDefinitionNode> getAllFunctionHeads() {
        return this.functions.values();
    }

    @Override
    public CFAFunctionDefinitionNode getFunctionHead(String name) {
        return (CFAFunctionDefinitionNode)this.functions.get((Object)name);
    }

    public ImmutableMap<String, CFAFunctionDefinitionNode> getAllFunctions() {
        return this.functions;
    }

    public ImmutableSortedSet<CFANode> getAllNodes() {
        return this.allNodes;
    }

    @Override
    public CFAFunctionDefinitionNode getMainFunction() {
        return this.mainFunction;
    }

    @Override
    public Optional<ImmutableMultimap<String, CFAUtils.Loop>> getLoopStructure() {
        return this.loopStructure;
    }
}

