/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.util.ArrayList;
import java.util.HashSet;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.MultiEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;

class MultiEdgeCreator
extends CFATraversal.DefaultCFAVisitor {
    private final MutableCFA cfa;

    static void createMultiEdges(MutableCFA cfa) {
        CFATraversal.dfs().ignoreSummaryEdges().traverse(cfa.getMainFunction(), new CFATraversal.NodeCollectingCFAVisitor(new MultiEdgeCreator(cfa)));
    }

    private MultiEdgeCreator(MutableCFA pCfa) {
        this.cfa = pCfa;
    }

    @Override
    public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
        if (this.nodeQualifiesAsStartNode(pNode)) {
            CFAEdge edge;
            ArrayList<CFAEdge> edges = new ArrayList<CFAEdge>();
            HashSet<CFANode> nodes = new HashSet<CFANode>();
            CFANode node = pNode;
            while (this.edgeQualifies(edge = node.getLeavingEdge(0))) {
                edges.add(edge);
                nodes.add(edge.getPredecessor());
                nodes.add(edge.getSuccessor());
                node = edge.getSuccessor();
                if (this.nodeQualifies(node)) continue;
            }
            if (edges.size() > 1) {
                CFAEdge firstEdge = (CFAEdge)edges.get(0);
                CFANode firstNode = firstEdge.getPredecessor();
                assert (firstNode == pNode);
                CFAEdge lastEdge = (CFAEdge)edges.get(edges.size() - 1);
                CFANode lastNode = lastEdge.getSuccessor();
                firstNode.removeLeavingEdge(firstEdge);
                lastNode.removeEnteringEdge(lastEdge);
                MultiEdge newEdge = new MultiEdge(firstNode, lastNode, edges);
                firstNode.addLeavingEdge(newEdge);
                lastNode.addEnteringEdge(newEdge);
                nodes.remove(firstNode);
                nodes.remove(lastNode);
                assert (!nodes.isEmpty());
                for (CFANode middleNode : nodes) {
                    this.cfa.removeNode(middleNode);
                }
            }
        }
        return CFATraversal.TraversalProcess.CONTINUE;
    }

    private boolean nodeQualifiesAsStartNode(CFANode node) {
        return node.getNumLeavingEdges() == 1 && node.getLeavingSummaryEdge() == null;
    }

    private boolean nodeQualifies(CFANode node) {
        return node.getNumLeavingEdges() == 1 && node.getNumEnteringEdges() == 1 && node.getLeavingSummaryEdge() == null && !node.isLoopStart() && node.getClass() == CFANode.class;
    }

    private boolean edgeQualifies(CFAEdge edge) {
        return edge.getEdgeType() == CFAEdgeType.BlankEdge || edge.getEdgeType() == CFAEdgeType.DeclarationEdge || edge.getEdgeType() == CFAEdgeType.StatementEdge || edge.getEdgeType() == CFAEdgeType.ReturnStatementEdge;
    }
}

