/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ImmutableCFA;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class MutableCFA
implements CFA {
    private final Map<String, CFAFunctionDefinitionNode> functions;
    private final SortedSetMultimap<String, CFANode> allNodes;
    private final CFAFunctionDefinitionNode mainFunction;

    public MutableCFA(Map<String, CFAFunctionDefinitionNode> pFunctions, SortedSetMultimap<String, CFANode> pAllNodes, CFAFunctionDefinitionNode pMainFunction) {
        this.functions = pFunctions;
        this.allNodes = pAllNodes;
        this.mainFunction = pMainFunction;
        assert (((Object)this.functions.keySet()).equals(this.allNodes.keySet()));
        assert (this.functions.get(this.mainFunction.getFunctionName()) == this.mainFunction);
    }

    void addNode(CFANode pNode) {
        assert (this.functions.containsKey(pNode.getFunctionName()));
        this.allNodes.put((Object)pNode.getFunctionName(), (Object)pNode);
    }

    void clear() {
        this.functions.clear();
        this.allNodes.clear();
    }

    void removeNode(CFANode pNode) {
        SortedSet functionNodes = this.allNodes.get((Object)pNode.getFunctionName());
        assert (functionNodes.contains(pNode));
        functionNodes.remove(pNode);
        if (functionNodes.isEmpty()) {
            this.functions.remove(pNode.getFunctionName());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.functions.isEmpty();
    }

    @Override
    public int getNumberOfFunctions() {
        return this.functions.size();
    }

    @Override
    public Set<String> getAllFunctionNames() {
        return Collections.unmodifiableSet(this.functions.keySet());
    }

    @Override
    public Collection<CFAFunctionDefinitionNode> getAllFunctionHeads() {
        return Collections.unmodifiableCollection(this.functions.values());
    }

    @Override
    public CFAFunctionDefinitionNode getFunctionHead(String pName) {
        return this.functions.get(pName);
    }

    @Override
    public Map<String, CFAFunctionDefinitionNode> getAllFunctions() {
        return Collections.unmodifiableMap(this.functions);
    }

    public SortedSet<CFANode> getFunctionNodes(String pName) {
        return Collections.unmodifiableSortedSet(this.allNodes.get((Object)pName));
    }

    @Override
    public Collection<CFANode> getAllNodes() {
        return Collections.unmodifiableCollection(this.allNodes.values());
    }

    @Override
    public CFAFunctionDefinitionNode getMainFunction() {
        return this.mainFunction;
    }

    @Override
    public Optional<ImmutableMultimap<String, CFAUtils.Loop>> getLoopStructure() {
        return Optional.absent();
    }

    public ImmutableCFA makeImmutableCFA(Optional<ImmutableMultimap<String, CFAUtils.Loop>> pLoopStructure) {
        return new ImmutableCFA(this.functions, (SetMultimap<String, CFANode>)this.allNodes, this.mainFunction, pLoopStructure);
    }
}

