/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.cfa.ast.BasicType;
import org.sosy_lab.cpachecker.cfa.ast.IASTCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTElaboratedTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTEnumerationSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IASTFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTPointerTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IType;

public class Defaults {
    private static IType INT_TYPE = new IASTSimpleDeclSpecifier(false, false, BasicType.INT, false, false, true, false, false, false, false);

    private Defaults() {
    }

    public static IASTLiteralExpression forType(IType type, IASTFileLocation fileLoc) {
        if (type instanceof IASTPointerTypeSpecifier) {
            return new IASTIntegerLiteralExpression(fileLoc, INT_TYPE, BigInteger.ZERO);
        }
        if (type instanceof IASTSimpleDeclSpecifier) {
            BasicType basicType = ((IASTSimpleDeclSpecifier)type).getType();
            switch (basicType) {
                case CHAR: {
                    return new IASTCharLiteralExpression(fileLoc, type, '\u0000');
                }
                case DOUBLE: 
                case FLOAT: {
                    return new IASTFloatLiteralExpression(fileLoc, type, BigDecimal.ZERO);
                }
                case UNSPECIFIED: 
                case BOOL: 
                case INT: 
                case VOID: {
                    return new IASTIntegerLiteralExpression(fileLoc, type, BigInteger.ZERO);
                }
            }
            throw new AssertionError((Object)("Unknown basic type '" + (Object)((Object)basicType) + "'"));
        }
        if (type instanceof IASTEnumerationSpecifier) {
            return new IASTIntegerLiteralExpression(fileLoc, INT_TYPE, BigInteger.ZERO);
        }
        if (type instanceof IASTElaboratedTypeSpecifier && ((IASTElaboratedTypeSpecifier)type).getKind() == IASTElaboratedTypeSpecifier.ElaboratedType.ENUM) {
            return new IASTIntegerLiteralExpression(fileLoc, INT_TYPE, BigInteger.ZERO);
        }
        return null;
    }
}

