/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import org.sosy_lab.cpachecker.cfa.ast.ExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;

public final class IASTArraySubscriptExpression
extends IASTExpression {
    private final IASTExpression arrayExpression;
    private final IASTExpression subscriptExpression;

    public IASTArraySubscriptExpression(IASTFileLocation pFileLocation, IType pType, IASTExpression pArrayExpression, IASTExpression pSubscriptExpression) {
        super(pFileLocation, pType);
        this.arrayExpression = pArrayExpression;
        this.subscriptExpression = pSubscriptExpression;
    }

    public IASTExpression getArrayExpression() {
        return this.arrayExpression;
    }

    public IASTExpression getSubscriptExpression() {
        return this.subscriptExpression;
    }

    @Override
    public <R, X extends Exception> R accept(ExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(RightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString() {
        String left = this.arrayExpression instanceof IASTArraySubscriptExpression ? this.arrayExpression.toASTString() : this.arrayExpression.toParenthesizedASTString();
        return left + "[" + this.subscriptExpression.toASTString() + "]";
    }
}

