/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import org.sosy_lab.cpachecker.cfa.ast.ExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;

public class IASTBinaryExpression
extends IASTExpression {
    private final IASTExpression operand1;
    private final IASTExpression operand2;
    private final BinaryOperator operator;

    public IASTBinaryExpression(IASTFileLocation pFileLocation, IType pType, IASTExpression pOperand1, IASTExpression pOperand2, BinaryOperator pOperator) {
        super(pFileLocation, pType);
        this.operand1 = pOperand1;
        this.operand2 = pOperand2;
        this.operator = pOperator;
    }

    public IASTExpression getOperand1() {
        return this.operand1;
    }

    public IASTExpression getOperand2() {
        return this.operand2;
    }

    public BinaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public <R, X extends Exception> R accept(ExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(RightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString() {
        return this.operand1.toParenthesizedASTString() + " " + this.operator.getOperator() + " " + this.operand2.toParenthesizedASTString();
    }

    public static enum BinaryOperator {
        MULTIPLY("*"),
        DIVIDE("/"),
        MODULO("%"),
        PLUS("+"),
        MINUS("-"),
        SHIFT_LEFT("<<"),
        SHIFT_RIGHT(">>"),
        LESS_THAN("<"),
        GREATER_THAN(">"),
        LESS_EQUAL("<="),
        GREATER_EQUAL(">="),
        BINARY_AND("&"),
        BINARY_XOR("^"),
        BINARY_OR("|"),
        LOGICAL_AND("&&"),
        LOGICAL_OR("||"),
        EQUALS("=="),
        NOT_EQUALS("!=");

        private final String op;

        private BinaryOperator(String pOp) {
            this.op = pOp;
        }

        public String getOperator() {
            return this.op;
        }
    }
}

