/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import org.sosy_lab.cpachecker.cfa.ast.ExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;

public class IASTCharLiteralExpression
extends IASTLiteralExpression {
    private final char character;

    public IASTCharLiteralExpression(IASTFileLocation pFileLocation, IType pType, char pCharacter) {
        super(pFileLocation, pType);
        this.character = pCharacter;
    }

    public char getCharacter() {
        return this.character;
    }

    @Override
    public Character getValue() {
        return Character.valueOf(this.getCharacter());
    }

    @Override
    public <R, X extends Exception> R accept(ExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(RightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString() {
        if (this.character >= ' ' && this.character < '\u0080') {
            return "'" + this.character + "'";
        }
        return "'\\x" + Integer.toHexString(this.character) + "'";
    }
}

