/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IType;

public final class IASTCompositeTypeSpecifier
extends IType {
    private final int key;
    private final List<IASTCompositeTypeMemberDeclaration> members;
    private final String name;
    public static final int k_struct = 1;
    public static final int k_union = 2;

    public IASTCompositeTypeSpecifier(boolean pConst, boolean pVolatile, int pKey, List<IASTCompositeTypeMemberDeclaration> pMembers, String pName) {
        super(pConst, pVolatile);
        this.key = pKey;
        this.members = ImmutableList.copyOf(pMembers);
        this.name = pName;
    }

    public int getKey() {
        return this.key;
    }

    public List<IASTCompositeTypeMemberDeclaration> getMembers() {
        return this.members;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toASTString(String pDeclarator) {
        StringBuilder lASTString = new StringBuilder();
        if (this.isConst()) {
            lASTString.append("const ");
        }
        if (this.isVolatile()) {
            lASTString.append("volatile ");
        }
        if (this.key == 1) {
            lASTString.append("struct ");
        } else if (this.key == 2) {
            lASTString.append("union ");
        } else {
            lASTString.append("unknown ");
        }
        lASTString.append(this.name);
        lASTString.append(" {\n");
        for (IASTCompositeTypeMemberDeclaration lMember : this.members) {
            lASTString.append("  ");
            lASTString.append(lMember.toASTString());
            lASTString.append("\n");
        }
        lASTString.append("} ");
        lASTString.append(pDeclarator);
        return lASTString.toString();
    }

    public static final class IASTCompositeTypeMemberDeclaration
    extends IASTSimpleDeclaration {
        public IASTCompositeTypeMemberDeclaration(IASTFileLocation pFileLocation, IType pSpecifier, String pName) {
            super(pFileLocation, pSpecifier, pName);
        }
    }
}

