/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import org.sosy_lab.cpachecker.cfa.ast.IType;

public final class IASTElaboratedTypeSpecifier
extends IType {
    private final ElaboratedType kind;
    private final String name;

    public IASTElaboratedTypeSpecifier(boolean pConst, boolean pVolatile, ElaboratedType pKind, String pName) {
        super(pConst, pVolatile);
        this.kind = pKind;
        this.name = pName;
    }

    public String getName() {
        return this.name;
    }

    public ElaboratedType getKind() {
        return this.kind;
    }

    @Override
    public String toASTString(String pDeclarator) {
        StringBuilder lASTString = new StringBuilder();
        if (this.isConst()) {
            lASTString.append("const ");
        }
        if (this.isVolatile()) {
            lASTString.append("volatile ");
        }
        lASTString.append(this.kind.toASTString());
        lASTString.append(this.name);
        lASTString.append(" ");
        lASTString.append(pDeclarator);
        return lASTString.toString();
    }

    public static enum ElaboratedType {
        ENUM,
        STRUCT,
        UNION;


        public String toASTString() {
            return this.name().toLowerCase() + " ";
        }
    }
}

