/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.ASTStringIterable;
import org.sosy_lab.cpachecker.cfa.ast.BasicType;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IType;

public final class IASTEnumerationSpecifier
extends IType {
    private final List<IASTEnumerator> enumerators;
    private final String name;

    public IASTEnumerationSpecifier(boolean pConst, boolean pVolatile, List<IASTEnumerator> pEnumerators, String pName) {
        super(pConst, pVolatile);
        this.enumerators = ImmutableList.copyOf(pEnumerators);
        this.name = pName;
    }

    public IASTEnumerator[] getEnumerators() {
        return this.enumerators.toArray(new IASTEnumerator[this.enumerators.size()]);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toASTString(String pDeclarator) {
        StringBuilder lASTString = new StringBuilder();
        if (this.isConst()) {
            lASTString.append("const ");
        }
        if (this.isVolatile()) {
            lASTString.append("volatile ");
        }
        lASTString.append("enum ");
        lASTString.append(this.name);
        lASTString.append(" {\n  ");
        lASTString.append(Joiner.on((String)",\n  ").join((Iterable)new ASTStringIterable(this.enumerators)));
        lASTString.append("\n} ");
        lASTString.append(pDeclarator);
        return lASTString.toString();
    }

    public static final class IASTEnumerator
    extends IASTSimpleDeclaration {
        private static final IType INT_TYPE = new IASTSimpleDeclSpecifier(true, false, BasicType.INT, false, false, true, false, false, false, false);
        private final Long value;

        public IASTEnumerator(IASTFileLocation pFileLocation, String pName, Long pValue) {
            super(pFileLocation, INT_TYPE, pName);
            Preconditions.checkNotNull((Object)pName);
            this.value = pValue;
        }

        public long getValue() {
            Preconditions.checkState((this.value != null ? 1 : 0) != 0, (Object)"Need to check hasValue() before calling getValue()");
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        @Override
        public String toASTString() {
            return this.getName() + (this.hasValue() ? " = " + String.valueOf(this.value) : "");
        }
    }
}

