/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import org.sosy_lab.cpachecker.cfa.ast.ExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;

public final class IASTFieldReference
extends IASTExpression {
    private final String name;
    private final IASTExpression owner;
    private final boolean isPointerDereference;

    public IASTFieldReference(IASTFileLocation pFileLocation, IType pType, String pName, IASTExpression pOwner, boolean pIsPointerDereference) {
        super(pFileLocation, pType);
        this.name = pName;
        this.owner = pOwner;
        this.isPointerDereference = pIsPointerDereference;
    }

    public String getFieldName() {
        return this.name;
    }

    public IASTExpression getFieldOwner() {
        return this.owner;
    }

    public boolean isPointerDereference() {
        return this.isPointerDereference;
    }

    @Override
    public <R, X extends Exception> R accept(ExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(RightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString() {
        String left = this.owner instanceof IASTFieldReference ? this.owner.toASTString() : this.owner.toParenthesizedASTString();
        String op = this.isPointerDereference ? "->" : ".";
        return left + op + this.name;
    }
}

