/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.ASTStringIterable;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;

public class IASTFunctionCallExpression
extends IASTRightHandSide {
    private final IASTExpression functionName;
    private final List<IASTExpression> parameters;
    private final IASTSimpleDeclaration declaration;

    public IASTFunctionCallExpression(IASTFileLocation pFileLocation, IType pType, IASTExpression pFunctionName, List<IASTExpression> pParameters, IASTSimpleDeclaration pDeclaration) {
        super(pFileLocation, pType);
        this.functionName = pFunctionName;
        this.parameters = ImmutableList.copyOf(pParameters);
        this.declaration = pDeclaration;
    }

    public IASTExpression getFunctionNameExpression() {
        return this.functionName;
    }

    public List<IASTExpression> getParameterExpressions() {
        return this.parameters;
    }

    public IASTSimpleDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public <R, X extends Exception> R accept(RightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString() {
        StringBuilder lASTString = new StringBuilder();
        lASTString.append(this.functionName.toParenthesizedASTString());
        lASTString.append("(");
        Joiner.on((String)", ").appendTo(lASTString, (Iterable)new ASTStringIterable(this.parameters));
        lASTString.append(")");
        return lASTString.toString();
    }
}

