/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.ASTStringIterable;
import org.sosy_lab.cpachecker.cfa.ast.IASTParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IType;

public class IASTFunctionTypeSpecifier
extends IType {
    private final IType returnType;
    private String name = null;
    private final List<IASTParameterDeclaration> parameters;
    private final boolean takesVarArgs;

    public IASTFunctionTypeSpecifier(boolean pConst, boolean pVolatile, IType pReturnType, List<IASTParameterDeclaration> pParameters, boolean pTakesVarArgs) {
        super(pConst, pVolatile);
        this.returnType = pReturnType;
        this.parameters = ImmutableList.copyOf(pParameters);
        this.takesVarArgs = pTakesVarArgs;
    }

    public IType getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String pName) {
        Preconditions.checkState((this.name == null ? 1 : 0) != 0);
        this.name = pName;
    }

    public List<IASTParameterDeclaration> getParameters() {
        return this.parameters;
    }

    public boolean takesVarArgs() {
        return this.takesVarArgs;
    }

    @Override
    public String toASTString(String pDeclarator) {
        StringBuilder lASTString = new StringBuilder();
        if (this.isConst()) {
            lASTString.append("const ");
        }
        if (this.isVolatile()) {
            lASTString.append("volatile ");
        }
        lASTString.append(this.returnType.toASTString(""));
        lASTString.append(" ");
        if (pDeclarator.startsWith("*")) {
            lASTString.append("(");
            lASTString.append(pDeclarator);
            lASTString.append(")");
        } else {
            lASTString.append(pDeclarator);
        }
        lASTString.append("(");
        Joiner.on((String)", ").appendTo(lASTString, (Iterable)new ASTStringIterable(this.parameters));
        if (this.takesVarArgs) {
            if (!this.parameters.isEmpty()) {
                lASTString.append(", ");
            }
            lASTString.append("...");
        }
        lASTString.append(")");
        return lASTString.toString();
    }
}

