/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.cfa.ast.ExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;

public class IASTIntegerLiteralExpression
extends IASTLiteralExpression {
    private final BigInteger value;

    public IASTIntegerLiteralExpression(IASTFileLocation pFileLocation, IType pType, BigInteger pValue) {
        super(pFileLocation, pType);
        this.value = pValue;
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    public long asLong() {
        return this.value.longValue();
    }

    @Override
    public <R, X extends Exception> R accept(ExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(RightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString() {
        String suffix = "";
        IType iType = this.getExpressionType();
        if (iType instanceof IASTSimpleDeclSpecifier) {
            IASTSimpleDeclSpecifier type = (IASTSimpleDeclSpecifier)iType;
            if (type.isUnsigned()) {
                suffix = suffix + "U";
            }
            if (type.isLong()) {
                suffix = suffix + "L";
            } else if (type.isLongLong()) {
                suffix = suffix + "LL";
            }
        }
        return this.value.toString() + suffix;
    }
}

