/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import org.sosy_lab.cpachecker.cfa.ast.BasicType;
import org.sosy_lab.cpachecker.cfa.ast.IType;

public final class IASTSimpleDeclSpecifier
extends IType {
    private final BasicType type;
    private final boolean isLong;
    private final boolean isShort;
    private final boolean isSigned;
    private final boolean isUnsigned;
    private final boolean isComplex;
    private final boolean isImaginary;
    private final boolean isLongLong;

    public IASTSimpleDeclSpecifier(boolean pConst, boolean pVolatile, BasicType pType, boolean pIsLong, boolean pIsShort, boolean pIsSigned, boolean pIsUnsigned, boolean pIsComplex, boolean pIsImaginary, boolean pIsLongLong) {
        super(pConst, pVolatile);
        this.type = pType;
        this.isLong = pIsLong;
        this.isShort = pIsShort;
        this.isSigned = pIsSigned;
        this.isUnsigned = pIsUnsigned;
        this.isComplex = pIsComplex;
        this.isImaginary = pIsImaginary;
        this.isLongLong = pIsLongLong;
    }

    public BasicType getType() {
        return this.type;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public boolean isShort() {
        return this.isShort;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public boolean isImaginary() {
        return this.isImaginary;
    }

    public boolean isLongLong() {
        return this.isLongLong;
    }

    @Override
    public String toASTString(String pDeclarator) {
        ArrayList<String> parts = new ArrayList<String>();
        if (this.isConst()) {
            parts.add("const");
        }
        if (this.isVolatile()) {
            parts.add("volatile");
        }
        if (this.isUnsigned) {
            parts.add("unsigned");
        } else if (this.isSigned) {
            parts.add("signed");
        }
        if (this.isLongLong) {
            parts.add("long long");
        } else if (this.isLong) {
            parts.add("long");
        } else if (this.isShort) {
            parts.add("short");
        }
        if (this.isImaginary) {
            parts.add("_Imaginary");
        }
        if (this.isComplex) {
            parts.add("_Complex");
        }
        parts.add(Strings.emptyToNull((String)this.type.toASTString()));
        parts.add(Strings.emptyToNull((String)pDeclarator));
        return Joiner.on((char)' ').skipNulls().join(parts);
    }
}

