/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.ast.IType;

public abstract class IASTSimpleDeclaration
extends IASTNode {
    private final IType specifier;
    private final String name;
    private final String origName;

    public IASTSimpleDeclaration(IASTFileLocation pFileLocation, IType pSpecifier, String pName) {
        this(pFileLocation, pSpecifier, pName, pName);
    }

    public IASTSimpleDeclaration(IASTFileLocation pFileLocation, IType pSpecifier, String pName, String pOrigName) {
        super(pFileLocation);
        this.specifier = (IType)Preconditions.checkNotNull((Object)pSpecifier);
        this.name = pName;
        this.origName = pOrigName;
    }

    public IType getDeclSpecifier() {
        return this.specifier;
    }

    public String getName() {
        return this.name;
    }

    public String getOrigName() {
        return this.origName;
    }

    @Override
    public String toASTString() {
        String name = Strings.nullToEmpty((String)this.getName());
        return this.getDeclSpecifier().toASTString(name) + ";";
    }
}

