/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import org.sosy_lab.cpachecker.cfa.ast.ExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;

public final class IASTTypeIdExpression
extends IASTExpression {
    private final TypeIdOperator operator;
    private final IType type;

    public IASTTypeIdExpression(IASTFileLocation pFileLocation, IType pExpressionType, TypeIdOperator pOperator, IType pType) {
        super(pFileLocation, pExpressionType);
        this.operator = pOperator;
        this.type = pType;
    }

    public TypeIdOperator getOperator() {
        return this.operator;
    }

    public IType getType() {
        return this.type;
    }

    @Override
    public <R, X extends Exception> R accept(ExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(RightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString() {
        return this.operator.getOperator() + "(" + this.type.toASTString("") + ")";
    }

    public static enum TypeIdOperator {
        SIZEOF,
        TYPEID,
        ALIGNOF,
        TYPEOF;


        public String getOperator() {
            return this.toString().toLowerCase();
        }
    }
}

