/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import org.sosy_lab.cpachecker.cfa.ast.ExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;

public class IASTUnaryExpression
extends IASTExpression {
    private final IASTExpression operand;
    private final UnaryOperator operator;

    public IASTUnaryExpression(IASTFileLocation pFileLocation, IType pType, IASTExpression pOperand, UnaryOperator pOperator) {
        super(pFileLocation, pType);
        this.operand = pOperand;
        this.operator = pOperator;
    }

    public IASTExpression getOperand() {
        return this.operand;
    }

    public UnaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public <R, X extends Exception> R accept(ExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(RightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public String toASTString() {
        return this.operator.getOperator() + this.operand.toParenthesizedASTString();
    }

    public static enum UnaryOperator {
        PLUS("+"),
        MINUS("-"),
        STAR("*"),
        AMPER("&"),
        TILDE("~"),
        NOT("!"),
        SIZEOF("sizeof");

        private final String mOp;

        private UnaryOperator(String pOp) {
            this.mOp = pOp;
        }

        public String getOperator() {
            return this.mOp;
        }
    }
}

