/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializer;
import org.sosy_lab.cpachecker.cfa.ast.IType;
import org.sosy_lab.cpachecker.cfa.ast.StorageClass;

public final class IASTVariableDeclaration
extends IASTDeclaration {
    private final StorageClass storageClass;
    private final IASTInitializer initializer;

    public IASTVariableDeclaration(IASTFileLocation pFileLocation, boolean pIsGlobal, StorageClass pStorageClass, IType pSpecifier, String pName, String pOrigName, IASTInitializer pInitializer) {
        super(pFileLocation, pIsGlobal, pSpecifier, (String)Preconditions.checkNotNull((Object)pName), pOrigName);
        this.storageClass = pStorageClass;
        this.initializer = pInitializer;
        Preconditions.checkArgument((this.storageClass != StorageClass.EXTERN || this.initializer == null ? 1 : 0) != 0, (Object)"Extern declarations cannot have an initializer");
        Preconditions.checkArgument((this.storageClass == StorageClass.EXTERN || this.storageClass == StorageClass.AUTO ? 1 : 0) != 0, (Object)("StorageClass is " + (Object)((Object)this.storageClass)));
        Preconditions.checkArgument((pIsGlobal || this.storageClass == StorageClass.AUTO ? 1 : 0) != 0);
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public IASTInitializer getInitializer() {
        return this.initializer;
    }

    @Override
    public String toASTString() {
        StringBuilder lASTString = new StringBuilder();
        lASTString.append(this.storageClass.toASTString());
        lASTString.append(this.getDeclSpecifier().toASTString(this.getName()));
        if (this.initializer != null) {
            lASTString.append(" = ");
            lASTString.append(this.initializer.toASTString());
        }
        lASTString.append(";");
        return lASTString.toString();
    }
}

