/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;

public class NumericTypes {
    public static final IASTIntegerLiteralExpression ZERO = NumericTypes.create(0L);
    public static final IASTIntegerLiteralExpression ONE = NumericTypes.create(1L);
    public static final IASTIntegerLiteralExpression FALSE = ZERO;
    public static final IASTIntegerLiteralExpression TRUE = ONE;
    public static final IASTIntegerLiteralExpression INT_MAX = NumericTypes.create(Integer.MAX_VALUE);
    public static final IASTIntegerLiteralExpression INT_MIN = NumericTypes.create(Integer.MIN_VALUE);
    public static final IASTIntegerLiteralExpression UINT_MIN = ZERO;
    public static final IASTIntegerLiteralExpression UINT_MAX = NumericTypes.create(0xFFFFFFFFL);
    public static final IASTIntegerLiteralExpression LONG_MAX = NumericTypes.create(Integer.MAX_VALUE);
    public static final IASTIntegerLiteralExpression LONG_MIN = NumericTypes.create(Integer.MIN_VALUE);
    public static final IASTIntegerLiteralExpression ULONG_MIN = ZERO;
    public static final IASTIntegerLiteralExpression ULONG_MAX = NumericTypes.create(0xFFFFFFFFL);
    public static final IASTIntegerLiteralExpression SHRT_MAX = NumericTypes.create(32767L);
    public static final IASTIntegerLiteralExpression SHRT_MIN = NumericTypes.create(-32768L);
    public static final IASTIntegerLiteralExpression USHRT_MIN = ZERO;
    public static final IASTIntegerLiteralExpression USHRT_MAX = NumericTypes.create(65535L);
    public static final IASTIntegerLiteralExpression CHAR_MAX = NumericTypes.create(127L);
    public static final IASTIntegerLiteralExpression CHAR_MIN = NumericTypes.create(-128L);
    public static final IASTIntegerLiteralExpression UCHAR_MIN = ZERO;
    public static final IASTIntegerLiteralExpression UCHAR_MAX = NumericTypes.create(255L);

    private NumericTypes() {
    }

    private static IASTIntegerLiteralExpression create(long l) {
        return new IASTIntegerLiteralExpression(null, null, BigInteger.valueOf(l));
    }
}

