/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;

public class BlockPartitioning {
    private final Block mainBlock;
    private final Map<CFANode, Block> callNodeToBlock;
    private final Map<CFANode, Block> returnNodeToBlock;

    public BlockPartitioning(Collection<Block> subtrees, CFANode mainFunction) {
        Block mainBlock = null;
        HashMap<CFANode, Block> callNodeToSubtree = new HashMap<CFANode, Block>();
        HashMap<CFANode, Block> returnNodeToBlock = new HashMap<CFANode, Block>();
        for (Block subtree : subtrees) {
            for (CFANode callNode : subtree.getCallNodes()) {
                if (callNode instanceof CFAFunctionDefinitionNode && callNode.getFunctionName().equalsIgnoreCase(mainFunction.getFunctionName())) {
                    assert (mainBlock == null);
                    mainBlock = subtree;
                }
                callNodeToSubtree.put(callNode, subtree);
            }
            for (CFANode returnNode : subtree.getReturnNodes()) {
                returnNodeToBlock.put(returnNode, subtree);
            }
        }
        assert (mainBlock != null);
        this.mainBlock = mainBlock;
        this.callNodeToBlock = ImmutableMap.copyOf(callNodeToSubtree);
        this.returnNodeToBlock = ImmutableMap.copyOf(returnNodeToBlock);
    }

    public boolean isCallNode(CFANode node) {
        return this.callNodeToBlock.containsKey(node);
    }

    public Block getBlockForCallNode(CFANode node) {
        return this.callNodeToBlock.get(node);
    }

    public Block getMainBlock() {
        return this.mainBlock;
    }

    public boolean isReturnNode(CFANode node) {
        return this.returnNodeToBlock.keySet().contains(node);
    }

    public Block getBlockForReturnNode(CFANode pCurrentNode) {
        return this.returnNodeToBlock.get(pCurrentNode);
    }
}

