/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.ReferencedVariable;
import org.sosy_lab.cpachecker.cfa.blocks.builder.ReferencedVariablesCollector;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionExitNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;

public class BlockPartitioningBuilder {
    private final ReferencedVariablesCollector referenceCollector;
    private final Map<CFANode, Set<ReferencedVariable>> referencedVariablesMap = new HashMap<CFANode, Set<ReferencedVariable>>();
    private final Map<CFANode, Set<CFANode>> callNodesMap = new HashMap<CFANode, Set<CFANode>>();
    private final Map<CFANode, Set<CFANode>> returnNodesMap = new HashMap<CFANode, Set<CFANode>>();
    private final Map<CFANode, Set<CFAFunctionDefinitionNode>> innerFunctionCallsMap = new HashMap<CFANode, Set<CFAFunctionDefinitionNode>>();
    private final Map<CFANode, Set<CFANode>> blockNodesMap = new HashMap<CFANode, Set<CFANode>>();

    public BlockPartitioningBuilder(Set<CFANode> mainFunctionBody) {
        this.referenceCollector = new ReferencedVariablesCollector(mainFunctionBody);
    }

    public BlockPartitioning build(CFANode mainFunction) {
        boolean changed = true;
        block0: while (changed) {
            changed = false;
            for (CFANode node : this.referencedVariablesMap.keySet()) {
                for (CFAFunctionDefinitionNode calledFun : this.innerFunctionCallsMap.get(node)) {
                    Set<ReferencedVariable> functionVars = this.referencedVariablesMap.get(calledFun);
                    Set<CFANode> functionBody = this.blockNodesMap.get(calledFun);
                    if (functionVars == null || functionBody == null) {
                        assert (functionVars == null && functionBody == null);
                        CFATraversal.NodeCollectingCFAVisitor visitor = new CFATraversal.NodeCollectingCFAVisitor();
                        CFATraversal.dfs().ignoreFunctionCalls().traverse(calledFun, visitor);
                        functionBody = visitor.getVisitedNodes();
                        functionVars = this.collectReferencedVariables(functionBody);
                        this.blockNodesMap.put(calledFun, functionBody);
                        this.referencedVariablesMap.put(calledFun, functionVars);
                        this.innerFunctionCallsMap.put(calledFun, this.collectInnerFunctionCalls(functionBody));
                        changed = true;
                        continue block0;
                    }
                    if (this.referencedVariablesMap.get(node).addAll(functionVars)) {
                        changed = true;
                    }
                    if (!this.blockNodesMap.get(node).addAll(functionBody)) continue;
                    changed = true;
                }
            }
        }
        ArrayList<Block> blocks = new ArrayList<Block>(this.returnNodesMap.keySet().size());
        for (CFANode key : this.returnNodesMap.keySet()) {
            blocks.add(new Block(this.referencedVariablesMap.get(key), this.callNodesMap.get(key), this.returnNodesMap.get(key), this.blockNodesMap.get(key)));
        }
        return new BlockPartitioning(blocks, mainFunction);
    }

    public void addBlock(Set<CFANode> nodes, CFANode mainFunction) {
        Set<ReferencedVariable> referencedVariables = this.collectReferencedVariables(nodes);
        Set<CFANode> callNodes = this.collectCallNodes(nodes, mainFunction);
        Set<CFANode> returnNodes = this.collectReturnNodes(nodes, mainFunction);
        Set<CFAFunctionDefinitionNode> innerFunctionCalls = this.collectInnerFunctionCalls(nodes);
        CFANode registerNode = null;
        Iterator<CFANode> i$ = callNodes.iterator();
        while (i$.hasNext()) {
            CFANode node;
            registerNode = node = i$.next();
            if (!(node instanceof CFAFunctionDefinitionNode)) continue;
            break;
        }
        this.referencedVariablesMap.put(registerNode, referencedVariables);
        this.callNodesMap.put(registerNode, callNodes);
        this.returnNodesMap.put(registerNode, returnNodes);
        this.innerFunctionCallsMap.put(registerNode, innerFunctionCalls);
        this.blockNodesMap.put(registerNode, nodes);
    }

    private Set<CFAFunctionDefinitionNode> collectInnerFunctionCalls(Set<CFANode> pNodes) {
        HashSet<CFAFunctionDefinitionNode> result = new HashSet<CFAFunctionDefinitionNode>();
        for (CFANode node : pNodes) {
            for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
                CFAEdge e = node.getLeavingEdge(i);
                if (!(e instanceof FunctionCallEdge)) continue;
                result.add(((FunctionCallEdge)e).getSuccessor());
            }
        }
        return result;
    }

    private Set<CFANode> collectCallNodes(Set<CFANode> pNodes, CFANode mainFunction) {
        HashSet<CFANode> result = new HashSet<CFANode>();
        for (CFANode node : pNodes) {
            if (node instanceof CFAFunctionDefinitionNode && node.getFunctionName().equalsIgnoreCase(mainFunction.getFunctionName())) {
                result.add(node);
                continue;
            }
            if (node.getEnteringSummaryEdge() != null) {
                CFANode pred = node.getEnteringSummaryEdge().getPredecessor();
                if (pNodes.contains(pred)) continue;
                result.add(node);
                continue;
            }
            for (int i = 0; i < node.getNumEnteringEdges(); ++i) {
                CFANode pred = node.getEnteringEdge(i).getPredecessor();
                if (pNodes.contains(pred)) continue;
                result.add(node);
            }
        }
        return result;
    }

    private Set<CFANode> collectReturnNodes(Set<CFANode> pNodes, CFANode mainFunction) {
        HashSet<CFANode> result = new HashSet<CFANode>();
        for (CFANode node : pNodes) {
            if (node instanceof CFAFunctionExitNode && node.getFunctionName().equalsIgnoreCase(mainFunction.getFunctionName())) {
                result.add(node);
                continue;
            }
            for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
                CFANode succ = node.getLeavingEdge(i).getSuccessor();
                if (pNodes.contains(succ)) continue;
                if (!(node.getLeavingEdge(i) instanceof FunctionCallEdge)) {
                    result.add(node);
                    continue;
                }
                CFANode sumSucc = ((FunctionCallEdge)node.getLeavingEdge(i)).getSummaryEdge().getSuccessor();
                if (pNodes.contains(sumSucc)) continue;
                for (int j = 0; j < sumSucc.getNumEnteringEdges(); ++j) {
                    result.add(sumSucc.getEnteringEdge(j).getPredecessor());
                }
            }
        }
        return result;
    }

    private Set<ReferencedVariable> collectReferencedVariables(Set<CFANode> nodes) {
        return this.referenceCollector.collectVars(nodes);
    }
}

