/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import java.util.Set;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.builder.FunctionAndLoopPartitioning;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.util.CFATraversal;

public class DelayedFunctionAndLoopPartitioning
extends FunctionAndLoopPartitioning {
    public DelayedFunctionAndLoopPartitioning(LogManager pLogger, CFA pCfa) {
        super(pLogger, pCfa);
    }

    @Override
    protected Set<CFANode> getBlockForNode(CFANode pNode) {
        if (pNode instanceof CFAFunctionDefinitionNode) {
            CFATraversal.NodeCollectingCFAVisitor visitor = new CFATraversal.NodeCollectingCFAVisitor();
            CFATraversal.dfs().ignoreFunctionCalls().traverse(pNode, visitor);
            return this.removeInitialDeclarations(pNode, visitor.getVisitedNodes());
        }
        return super.getBlockForNode(pNode);
    }

    private Set<CFANode> removeInitialDeclarations(CFANode functionNode, Set<CFANode> functionBody) {
        CFAEdge edge;
        if (functionNode.getNumEnteringEdges() == 0) {
            return functionBody;
        }
        assert (functionNode.getNumLeavingEdges() == 1);
        CFANode currentNode = functionNode.getLeavingEdge(0).getSuccessor();
        functionBody.remove(functionNode);
        int skippedDeclarations = 0;
        while (currentNode.getNumLeavingEdges() == 1 && currentNode.getLeavingEdge(0).getSuccessor().getNumLeavingEdges() == 1) {
            assert (currentNode.getNumEnteringEdges() == 1);
            edge = currentNode.getLeavingEdge(0);
            if (edge.getEdgeType() != CFAEdgeType.DeclarationEdge) break;
            ++skippedDeclarations;
            functionBody.remove(edge.getPredecessor());
            currentNode = edge.getSuccessor();
        }
        while (currentNode.getNumLeavingEdges() == 1 && skippedDeclarations > 0 && currentNode.getLeavingEdge(0).getSuccessor().getNumLeavingEdges() == 1) {
            assert (currentNode.getNumEnteringEdges() == 1);
            edge = currentNode.getLeavingEdge(0);
            if (edge.getEdgeType() != CFAEdgeType.StatementEdge) break;
            --skippedDeclarations;
            System.out.println(edge);
            functionBody.remove(edge.getPredecessor());
            currentNode = edge.getSuccessor();
        }
        assert (currentNode.getNumEnteringEdges() == 1);
        return functionBody;
    }
}

