/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.builder.PartitioningHeuristic;
import org.sosy_lab.cpachecker.cfa.objectmodel.BlankEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class LoopPartitioning
extends PartitioningHeuristic {
    private Map<CFANode, Set<CFANode>> loopHeaderToLoopBody = null;
    private final CFA cfa;

    public LoopPartitioning(LogManager pLogger, CFA pCfa) {
        this.cfa = pCfa;
    }

    private void initLoopMap() {
        this.loopHeaderToLoopBody = new HashMap<CFANode, Set<CFANode>>();
        if (this.cfa.getLoopStructure().isPresent()) {
            for (String functionName : ((ImmutableMultimap)this.cfa.getLoopStructure().get()).keySet()) {
                for (CFAUtils.Loop loop : ((ImmutableMultimap)this.cfa.getLoopStructure().get()).get((Object)functionName)) {
                    if (loop.getLoopHeads().size() != 1) continue;
                    this.loopHeaderToLoopBody.put((CFANode)Iterables.getOnlyElement(loop.getLoopHeads()), (Set<CFANode>)loop.getLoopNodes());
                }
            }
        }
    }

    @Override
    protected boolean shouldBeCached(CFANode pNode) {
        if (pNode instanceof CFAFunctionDefinitionNode && pNode.getNumEnteringEdges() == 0) {
            return true;
        }
        if (pNode.isLoopStart()) {
            return !LoopPartitioning.hasBlankEdgeFromLoop(pNode) && !LoopPartitioning.selfLoop(pNode);
        }
        return false;
    }

    private static boolean hasBlankEdgeFromLoop(CFANode pNode) {
        for (int i = 0; i < pNode.getNumEnteringEdges(); ++i) {
            CFAEdge edge = pNode.getEnteringEdge(i);
            if (!(edge instanceof BlankEdge) || !edge.getPredecessor().isLoopStart()) continue;
            return true;
        }
        return false;
    }

    private static boolean selfLoop(CFANode pNode) {
        return pNode.getNumLeavingEdges() == 1 && pNode.getLeavingEdge(0).getSuccessor().equals(pNode);
    }

    @Override
    protected Set<CFANode> getBlockForNode(CFANode pNode) {
        if (pNode instanceof CFAFunctionDefinitionNode) {
            CFATraversal.NodeCollectingCFAVisitor visitor = new CFATraversal.NodeCollectingCFAVisitor();
            CFATraversal.dfs().ignoreFunctionCalls().traverse(pNode, visitor);
            return visitor.getVisitedNodes();
        }
        if (pNode.isLoopStart()) {
            Set<CFANode> immutableLoopBody;
            HashSet<CFANode> loopBody = new HashSet<CFANode>();
            if (this.loopHeaderToLoopBody == null) {
                this.initLoopMap();
            }
            if ((immutableLoopBody = this.loopHeaderToLoopBody.get(pNode)) == null) {
                return null;
            }
            loopBody.addAll(immutableLoopBody);
            this.insertLoopStartState(loopBody, pNode);
            this.insertLoopReturnStates(loopBody);
            return loopBody;
        }
        return null;
    }

    private void insertLoopStartState(Set<CFANode> pLoopBody, CFANode pLoopHeader) {
        for (int i = 0; i < pLoopHeader.getNumEnteringEdges(); ++i) {
            CFAEdge edge = pLoopHeader.getEnteringEdge(i);
            if (!(edge instanceof BlankEdge) || pLoopBody.contains(edge.getPredecessor())) continue;
            pLoopBody.add(edge.getPredecessor());
        }
    }

    private void insertLoopReturnStates(Set<CFANode> pLoopBody) {
        ArrayList<CFANode> addNodes = new ArrayList<CFANode>();
        for (CFANode node : pLoopBody) {
            for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
                CFAEdge edge = node.getLeavingEdge(i);
                if (pLoopBody.contains(edge.getSuccessor()) || node.getLeavingEdge(i) instanceof FunctionCallEdge) continue;
                addNodes.add(edge.getSuccessor());
            }
        }
        pLoopBody.addAll(addNodes);
    }
}

