/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.blocks.builder;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.DefaultExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.RightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.blocks.ReferencedVariable;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;

public class ReferencedVariablesCollector {
    Set<String> globalVars = new HashSet<String>();

    public ReferencedVariablesCollector(Collection<CFANode> mainNodes) {
        this.collectVars(mainNodes);
    }

    public Set<ReferencedVariable> collectVars(Collection<CFANode> nodes) {
        HashSet<ReferencedVariable> collectedVars = new HashSet<ReferencedVariable>();
        for (CFANode node : nodes) {
            for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
                CFAEdge leavingEdge = node.getLeavingEdge(i);
                if (!nodes.contains(leavingEdge.getSuccessor()) && !(leavingEdge instanceof FunctionCallEdge)) continue;
                this.collectVars(leavingEdge, collectedVars);
            }
        }
        return collectedVars;
    }

    private void collectVars(CFAEdge edge, Set<ReferencedVariable> pCollectedVars) {
        String currentFunction = edge.getPredecessor().getFunctionName();
        switch (edge.getEdgeType()) {
            case AssumeEdge: {
                AssumeEdge assumeEdge = (AssumeEdge)edge;
                this.collectVars(currentFunction, assumeEdge.getExpression(), null, pCollectedVars);
                break;
            }
            case BlankEdge: {
                break;
            }
            case CallToReturnEdge: {
                break;
            }
            case DeclarationEdge: {
                IASTDeclaration declaration = ((DeclarationEdge)edge).getDeclaration();
                boolean isGlobal = declaration.isGlobal();
                String varName = declaration.getName();
                if (!isGlobal) break;
                this.globalVars.add(varName);
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)edge;
                for (IASTExpression argument : functionCallEdge.getArguments()) {
                    this.collectVars(currentFunction, argument, null, pCollectedVars);
                }
                break;
            }
            case ReturnStatementEdge: {
                break;
            }
            case StatementEdge: {
                StatementEdge statementEdge = (StatementEdge)edge;
                if (!(statementEdge.getStatement() instanceof IASTAssignment)) break;
                IASTAssignment assignment = (IASTAssignment)((Object)statementEdge.getStatement());
                String lhsVarName = assignment.getLeftHandSide().toASTString();
                ReferencedVariable lhsVar = this.scoped(new ReferencedVariable(lhsVarName, false, true, null), currentFunction);
                pCollectedVars.add(lhsVar);
                this.collectVars(currentFunction, assignment.getRightHandSide(), lhsVar, pCollectedVars);
            }
        }
    }

    private void collectVars(String pCurrentFunction, IASTRightHandSide pNode, ReferencedVariable lhsVar, Set<ReferencedVariable> pCollectedVars) {
        pNode.accept(new CollectVariablesVisitor(pCurrentFunction, lhsVar, pCollectedVars));
    }

    private ReferencedVariable scoped(ReferencedVariable var, String function) {
        if (this.globalVars.contains(var.getName())) {
            return var;
        }
        return new ReferencedVariable(function + "::" + var, var.occursInCondition(), var.occursOnLhs(), var.getLhsVariable());
    }

    private class CollectVariablesVisitor
    extends DefaultExpressionVisitor<Void, RuntimeException>
    implements RightHandSideVisitor<Void, RuntimeException> {
        private final String currentFunction;
        private final ReferencedVariable lhsVar;
        private final Set<ReferencedVariable> collectedVars;

        public CollectVariablesVisitor(String pCurrentFunction, ReferencedVariable pLhsVar, Set<ReferencedVariable> pCollectedVars) {
            this.currentFunction = pCurrentFunction;
            this.lhsVar = pLhsVar;
            this.collectedVars = pCollectedVars;
        }

        private void collectVar(String var) {
            if (this.lhsVar == null) {
                this.collectedVars.add(ReferencedVariablesCollector.this.scoped(new ReferencedVariable(var, true, false, null), this.currentFunction));
            } else {
                this.collectedVars.add(ReferencedVariablesCollector.this.scoped(new ReferencedVariable(var, false, false, this.lhsVar), this.currentFunction));
            }
        }

        @Override
        public Void visit(IASTIdExpression pE) {
            this.collectVar(pE.getName());
            return null;
        }

        @Override
        public Void visit(IASTArraySubscriptExpression pE) {
            this.collectVar(pE.toASTString());
            ((IASTRightHandSide)pE.getArrayExpression()).accept(this);
            ((IASTRightHandSide)pE.getSubscriptExpression()).accept(this);
            return null;
        }

        @Override
        public Void visit(IASTBinaryExpression pE) {
            ((IASTRightHandSide)pE.getOperand1()).accept(this);
            ((IASTRightHandSide)pE.getOperand2()).accept(this);
            return null;
        }

        @Override
        public Void visit(IASTCastExpression pE) {
            ((IASTRightHandSide)pE.getOperand()).accept(this);
            return null;
        }

        @Override
        public Void visit(IASTFieldReference pE) {
            this.collectVar(pE.toASTString());
            ((IASTRightHandSide)pE.getFieldOwner()).accept(this);
            return null;
        }

        @Override
        public Void visit(IASTFunctionCallExpression pE) {
            ((IASTRightHandSide)pE.getFunctionNameExpression()).accept(this);
            for (IASTExpression param : pE.getParameterExpressions()) {
                ((IASTRightHandSide)param).accept(this);
            }
            return null;
        }

        @Override
        public Void visit(IASTUnaryExpression pE) {
            IASTUnaryExpression.UnaryOperator op = pE.getOperator();
            switch (op) {
                case AMPER: 
                case STAR: {
                    this.collectVar(pE.toASTString());
                }
            }
            ((IASTRightHandSide)pE.getOperand()).accept(this);
            return null;
        }

        @Override
        protected Void visitDefault(IASTExpression pExp) {
            return null;
        }
    }
}

