/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.objectmodel;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;

public abstract class AbstractCFAEdge
implements CFAEdge {
    private final CFANode predecessor;
    private final CFANode successor;
    private final String rawStatement;
    private final int lineNumber;

    public AbstractCFAEdge(String pRawStatement, int pLineNumber, CFANode pPredecessor, CFANode pSuccessor) {
        Preconditions.checkNotNull((Object)pRawStatement);
        Preconditions.checkNotNull((Object)pPredecessor);
        Preconditions.checkNotNull((Object)pSuccessor);
        this.predecessor = pPredecessor;
        this.successor = pSuccessor;
        this.rawStatement = pRawStatement;
        this.lineNumber = pLineNumber;
    }

    @Override
    public CFANode getPredecessor() {
        return this.predecessor;
    }

    @Override
    public CFANode getSuccessor() {
        return this.successor;
    }

    @Override
    public String getRawStatement() {
        return this.rawStatement;
    }

    @Override
    public Optional<?> getRawAST() {
        return Optional.absent();
    }

    @Override
    public String getDescription() {
        return this.getCode();
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public int hashCode() {
        return 31 * this.predecessor.hashCode() + this.successor.hashCode();
    }

    public boolean equals(Object pOther) {
        if (!(pOther instanceof AbstractCFAEdge)) {
            return false;
        }
        AbstractCFAEdge otherEdge = (AbstractCFAEdge)pOther;
        return otherEdge.predecessor == this.predecessor && otherEdge.successor == this.successor;
    }

    @Override
    public String toString() {
        return "Line " + this.getLineNumber() + ":\t" + this.getPredecessor() + " -{" + this.getDescription().replaceAll("\n", " ") + "}-> " + this.getSuccessor();
    }
}

