/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.objectmodel;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;

public class CFANode
implements Comparable<CFANode> {
    private static int nextNodeNumber = 0;
    private final int nodeNumber;
    private final int lineNumber;
    private final List<CFAEdge> leavingEdges = new ArrayList<CFAEdge>();
    private final List<CFAEdge> enteringEdges = new ArrayList<CFAEdge>();
    private boolean isLoopStart = false;
    private final String functionName;
    private CallToReturnEdge leavingSummaryEdge = null;
    private CallToReturnEdge enteringSummaryEdge = null;
    private int topologicalSortId = 0;

    public CFANode(int pLineNumber, String pFunctionName) {
        assert (!pFunctionName.isEmpty());
        this.lineNumber = pLineNumber;
        this.functionName = pFunctionName;
        this.nodeNumber = nextNodeNumber++;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public int getTopologicalSortId() {
        return this.topologicalSortId;
    }

    public void setTopologicalSortId(int pId) {
        this.topologicalSortId = pId;
    }

    public void addLeavingEdge(CFAEdge pNewLeavingEdge) {
        Preconditions.checkArgument((pNewLeavingEdge.getPredecessor() == this ? 1 : 0) != 0, (String)"Cannot add edge \"%s\" to node %s as leaving edge", (Object[])new Object[]{pNewLeavingEdge, this});
        this.leavingEdges.add(pNewLeavingEdge);
    }

    public void removeLeavingEdge(CFAEdge pEdge) {
        boolean removed = this.leavingEdges.remove(pEdge);
        Preconditions.checkArgument((boolean)removed, (String)"Cannot remove non-existing leaving edge \"%s\" from node %s", (Object[])new Object[]{pEdge, this});
    }

    public int getNumLeavingEdges() {
        return this.leavingEdges.size();
    }

    public CFAEdge getLeavingEdge(int pIndex) {
        return this.leavingEdges.get(pIndex);
    }

    public void addEnteringEdge(CFAEdge pEnteringEdge) {
        Preconditions.checkArgument((pEnteringEdge.getSuccessor() == this ? 1 : 0) != 0, (String)"Cannot add edge \"%s\" to node %s as entering edge", (Object[])new Object[]{pEnteringEdge, this});
        this.enteringEdges.add(pEnteringEdge);
    }

    public void removeEnteringEdge(CFAEdge pEdge) {
        boolean removed = this.enteringEdges.remove(pEdge);
        Preconditions.checkArgument((boolean)removed, (String)"Cannot remove non-existing entering edge \"%s\" from node %s", (Object[])new Object[]{pEdge, this});
    }

    public int getNumEnteringEdges() {
        return this.enteringEdges.size();
    }

    public CFAEdge getEnteringEdge(int pIndex) {
        return this.enteringEdges.get(pIndex);
    }

    public CFAEdge getEdgeTo(CFANode pOther) {
        for (CFAEdge edge : this.leavingEdges) {
            if (edge.getSuccessor() != pOther) continue;
            return edge;
        }
        throw new IllegalArgumentException();
    }

    public boolean hasEdgeTo(CFANode pOther) {
        boolean hasEdge = false;
        for (CFAEdge edge : this.leavingEdges) {
            if (edge.getSuccessor() != pOther) continue;
            hasEdge = true;
            break;
        }
        return hasEdge;
    }

    public void setLoopStart() {
        this.isLoopStart = true;
    }

    public boolean isLoopStart() {
        return this.isLoopStart;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void addEnteringSummaryEdge(CallToReturnEdge pEdge) {
        Preconditions.checkState((this.leavingSummaryEdge == null ? 1 : 0) != 0, (String)"Cannot add two entering summary edges to node %s", (Object[])new Object[]{this});
        this.enteringSummaryEdge = pEdge;
    }

    public void addLeavingSummaryEdge(CallToReturnEdge pEdge) {
        Preconditions.checkState((this.leavingSummaryEdge == null ? 1 : 0) != 0, (String)"Cannot add two leaving summary edges to node %s", (Object[])new Object[]{this});
        this.leavingSummaryEdge = pEdge;
    }

    public CallToReturnEdge getEnteringSummaryEdge() {
        return this.enteringSummaryEdge;
    }

    public CallToReturnEdge getLeavingSummaryEdge() {
        return this.leavingSummaryEdge;
    }

    public void removeEnteringSummaryEdge(CallToReturnEdge pEdge) {
        Preconditions.checkArgument((this.enteringSummaryEdge == pEdge ? 1 : 0) != 0, (String)"Cannot remove non-existing entering summary edge \"%s\" from node \"%s\"", (Object[])new Object[]{pEdge, this});
        this.enteringSummaryEdge = null;
    }

    public void removeLeavingSummaryEdge(CallToReturnEdge pEdge) {
        Preconditions.checkArgument((this.leavingSummaryEdge == pEdge ? 1 : 0) != 0, (String)"Cannot remove non-existing leaving summary edge \"%s\" from node \"%s\"", (Object[])new Object[]{pEdge, this});
        this.leavingSummaryEdge = null;
    }

    public String toString() {
        return "N" + this.nodeNumber;
    }

    @Override
    public int compareTo(CFANode pOther) {
        return Ints.compare((int)this.nodeNumber, (int)pOther.nodeNumber);
    }
}

