/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.objectmodel;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.objectmodel.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;

public class MultiEdge
extends AbstractCFAEdge
implements Iterable<CFAEdge> {
    private final ImmutableList<CFAEdge> edges;

    public MultiEdge(CFANode pPredecessor, CFANode pSuccessor, List<CFAEdge> pEdges) {
        super("", pEdges.get(0).getLineNumber(), pPredecessor, pSuccessor);
        this.edges = ImmutableList.copyOf(pEdges);
    }

    public ImmutableList<CFAEdge> getEdges() {
        return this.edges;
    }

    @Override
    public Iterator<CFAEdge> iterator() {
        return this.edges.iterator();
    }

    @Override
    public CFAEdgeType getEdgeType() {
        return CFAEdgeType.MultiEdge;
    }

    @Override
    public final String getRawStatement() {
        return Joiner.on((char)'\n').join((Iterable)Lists.transform(this.edges, (Function)new Function<CFAEdge, String>(){

            public String apply(CFAEdge pInput) {
                return pInput.getRawStatement();
            }
        }));
    }

    @Override
    public String getCode() {
        return Joiner.on((char)'\n').join((Iterable)Lists.transform(this.edges, (Function)new Function<CFAEdge, String>(){

            public String apply(CFAEdge pInput) {
                return pInput.getCode();
            }
        }));
    }

    @Override
    public String getDescription() {
        return Joiner.on((char)'\n').join((Iterable)Lists.transform(this.edges, (Function)new Function<CFAEdge, String>(){

            public String apply(CFAEdge pInput) {
                return pInput.getDescription();
            }
        }));
    }

    @Override
    public String toString() {
        return Joiner.on((char)'\n').join(this.edges);
    }
}

