/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.objectmodel.c;

import com.google.common.base.Optional;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.objectmodel.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;

public class AssumeEdge
extends AbstractCFAEdge {
    private final boolean truthAssumption;
    private final IASTExpression expression;

    public AssumeEdge(String pRawStatement, int pLineNumber, CFANode pPredecessor, CFANode pSuccessor, IASTExpression pExpression, boolean pTruthAssumption) {
        super("[" + pRawStatement + "]", pLineNumber, pPredecessor, pSuccessor);
        this.truthAssumption = pTruthAssumption;
        this.expression = pExpression;
    }

    @Override
    public CFAEdgeType getEdgeType() {
        return CFAEdgeType.AssumeEdge;
    }

    public boolean getTruthAssumption() {
        return this.truthAssumption;
    }

    public IASTExpression getExpression() {
        return this.expression;
    }

    @Override
    public String getCode() {
        if (this.truthAssumption) {
            return this.expression.toASTString();
        }
        return "!(" + this.expression.toASTString() + ")";
    }

    @Override
    public String getDescription() {
        return "[" + this.getCode() + "]";
    }

    public Optional<IASTExpression> getRawAST() {
        return Optional.of((Object)this.expression);
    }
}

