/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.objectmodel.c;

import com.google.common.base.Optional;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.objectmodel.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.CallToReturnEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;

public class FunctionCallEdge
extends AbstractCFAEdge {
    private final IASTFunctionCall functionCall;
    private final CallToReturnEdge summaryEdge;

    public FunctionCallEdge(String pRawStatement, int pLineNumber, CFANode pPredecessor, FunctionDefinitionNode pSuccessor, IASTFunctionCall pFunctionCall, CallToReturnEdge pSummaryEdge) {
        super(pRawStatement, pLineNumber, pPredecessor, pSuccessor);
        this.functionCall = pFunctionCall;
        this.summaryEdge = pSummaryEdge;
    }

    @Override
    public CFAEdgeType getEdgeType() {
        return CFAEdgeType.FunctionCallEdge;
    }

    public CallToReturnEdge getSummaryEdge() {
        return this.summaryEdge;
    }

    public List<IASTExpression> getArguments() {
        return this.functionCall.getFunctionCallExpression().getParameterExpressions();
    }

    @Override
    public String getCode() {
        return this.functionCall.getFunctionCallExpression().toASTString();
    }

    public Optional<IASTStatement> getRawAST() {
        return Optional.of((Object)this.functionCall.asStatement());
    }

    @Override
    public FunctionDefinitionNode getSuccessor() {
        return (FunctionDefinitionNode)super.getSuccessor();
    }
}

