/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICBasicType;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.cfa.ast.BasicType;
import org.sosy_lab.cpachecker.cfa.ast.Defaults;
import org.sosy_lab.cpachecker.cfa.ast.DummyType;
import org.sosy_lab.cpachecker.cfa.ast.IASTArrayTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTCompositeTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTElaboratedTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTEnumerationSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.IASTFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializer;
import org.sosy_lab.cpachecker.cfa.ast.IASTInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.ast.IASTParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTPointerTypeSpecifier;
import org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IComplexType;
import org.sosy_lab.cpachecker.cfa.ast.StorageClass;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.Scope;

class ASTConverter {
    private final LogManager logger;
    private final boolean ignoreCasts;
    private Scope scope;
    private LinkedList<IASTNode> sideAssigment = new LinkedList();
    private static final Set<IASTBinaryExpression.BinaryOperator> BOOLEAN_BINARY_OPERATORS = ImmutableSet.of((Object)((Object)IASTBinaryExpression.BinaryOperator.EQUALS), (Object)((Object)IASTBinaryExpression.BinaryOperator.NOT_EQUALS), (Object)((Object)IASTBinaryExpression.BinaryOperator.GREATER_EQUAL), (Object)((Object)IASTBinaryExpression.BinaryOperator.GREATER_THAN), (Object)((Object)IASTBinaryExpression.BinaryOperator.LESS_EQUAL), (Object)((Object)IASTBinaryExpression.BinaryOperator.LESS_THAN), (Object[])new IASTBinaryExpression.BinaryOperator[]{IASTBinaryExpression.BinaryOperator.LOGICAL_AND, IASTBinaryExpression.BinaryOperator.LOGICAL_OR});

    public ASTConverter(Scope pScope, boolean pIgnoreCasts, LogManager pLogger) {
        this.scope = pScope;
        this.ignoreCasts = pIgnoreCasts;
        this.logger = pLogger;
    }

    private static void check(boolean assertion, String msg, org.eclipse.cdt.core.dom.ast.IASTNode astNode) throws CFAGenerationRuntimeException {
        if (!assertion) {
            throw new CFAGenerationRuntimeException(msg, astNode);
        }
    }

    public boolean existsSideAssignment() {
        return !this.sideAssigment.isEmpty();
    }

    public IASTNode getSideAssignment() {
        return this.sideAssigment.removeFirst();
    }

    private boolean isBooleanExpression(org.sosy_lab.cpachecker.cfa.ast.IASTExpression e) {
        if (e instanceof org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression) {
            return BOOLEAN_BINARY_OPERATORS.contains((Object)((org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression)e).getOperator());
        }
        if (e instanceof org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression) {
            return ((org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression)e).getOperator() == IASTUnaryExpression.UnaryOperator.NOT;
        }
        return false;
    }

    public org.sosy_lab.cpachecker.cfa.ast.IASTExpression convertBooleanExpression(IASTExpression e) {
        org.sosy_lab.cpachecker.cfa.ast.IASTExpression exp = this.convertExpressionWithoutSideEffects(e);
        if (!this.isBooleanExpression(exp)) {
            IASTIntegerLiteralExpression zero = new IASTIntegerLiteralExpression(exp.getFileLocation(), exp.getExpressionType(), BigInteger.ZERO);
            return new org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression(exp.getFileLocation(), exp.getExpressionType(), exp, zero, IASTBinaryExpression.BinaryOperator.NOT_EQUALS);
        }
        return exp;
    }

    public org.sosy_lab.cpachecker.cfa.ast.IASTExpression convertExpressionWithoutSideEffects(IASTExpression e) {
        IASTNode node = this.convertExpressionWithSideEffects(e);
        if (node == null || node instanceof org.sosy_lab.cpachecker.cfa.ast.IASTExpression) {
            return (org.sosy_lab.cpachecker.cfa.ast.IASTExpression)node;
        }
        if (node instanceof IASTFunctionCallExpression) {
            return this.addSideassignmentsForExpressionsWithoutSideEffects(node, e);
        }
        if (node instanceof IASTAssignment) {
            this.sideAssigment.add(node);
            return ((IASTAssignment)((Object)node)).getLeftHandSide();
        }
        throw new AssertionError((Object)("unknown expression " + node));
    }

    private org.sosy_lab.cpachecker.cfa.ast.IASTExpression addSideassignmentsForExpressionsWithoutSideEffects(IASTNode node, IASTExpression e) {
        String name = "__CPAchecker_TMP_";
        int i = 0;
        while (this.scope.variableNameInUse(name + i, name + i)) {
            ++i;
        }
        name = name + i;
        IASTVariableDeclaration decl = new IASTVariableDeclaration(node.getFileLocation(), false, StorageClass.AUTO, ((IASTFunctionCallExpression)node).getExpressionType(), name, name, null);
        this.scope.registerDeclaration(decl);
        this.sideAssigment.add(decl);
        IASTIdExpression tmp = new IASTIdExpression(this.convert(e.getFileLocation()), this.convert(e.getExpressionType()), name, decl);
        this.sideAssigment.add(new IASTFunctionCallAssignmentStatement(this.convert(e.getFileLocation()), tmp, (IASTFunctionCallExpression)node));
        return tmp;
    }

    protected IASTNode convertExpressionWithSideEffects(IASTExpression e) {
        assert (!(e instanceof org.sosy_lab.cpachecker.cfa.ast.IASTExpression));
        if (e == null) {
            return null;
        }
        if (e instanceof IASTArraySubscriptExpression) {
            return this.convert((IASTArraySubscriptExpression)e);
        }
        if (e instanceof IASTBinaryExpression) {
            return this.convert((IASTBinaryExpression)e);
        }
        if (e instanceof IASTCastExpression) {
            return this.convert((IASTCastExpression)e);
        }
        if (e instanceof org.eclipse.cdt.core.dom.ast.IASTFieldReference) {
            return this.convert((org.eclipse.cdt.core.dom.ast.IASTFieldReference)e);
        }
        if (e instanceof org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression) {
            return this.convert((org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression)e);
        }
        if (e instanceof org.eclipse.cdt.core.dom.ast.IASTIdExpression) {
            return this.convert((org.eclipse.cdt.core.dom.ast.IASTIdExpression)e);
        }
        if (e instanceof IASTLiteralExpression) {
            return this.convert((IASTLiteralExpression)e);
        }
        if (e instanceof IASTUnaryExpression) {
            return this.convert((IASTUnaryExpression)e);
        }
        if (e instanceof org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression) {
            return this.convert((org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression)e);
        }
        throw new CFAGenerationRuntimeException("", (org.eclipse.cdt.core.dom.ast.IASTNode)e);
    }

    private org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression convert(IASTArraySubscriptExpression e) {
        return new org.sosy_lab.cpachecker.cfa.ast.IASTArraySubscriptExpression(this.convert(e.getFileLocation()), this.convert(e.getExpressionType()), this.convertExpressionWithoutSideEffects(e.getArrayExpression()), this.convertExpressionWithoutSideEffects(e.getSubscriptExpression()));
    }

    private IASTNode convert(IASTBinaryExpression e) {
        org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation fileLoc = this.convert(e.getFileLocation());
        org.sosy_lab.cpachecker.cfa.ast.IType type = this.convert(e.getExpressionType());
        org.sosy_lab.cpachecker.cfa.ast.IASTExpression leftHandSide = this.convertExpressionWithoutSideEffects(e.getOperand1());
        Pair<IASTBinaryExpression.BinaryOperator, Boolean> opPair = this.convertBinaryOperator(e);
        IASTBinaryExpression.BinaryOperator op = (IASTBinaryExpression.BinaryOperator)((Object)opPair.getFirst());
        boolean isAssign = (Boolean)opPair.getSecond();
        if (isAssign) {
            if (op == null) {
                IASTNode rightHandSide = this.convertExpressionWithSideEffects(e.getOperand2());
                if (rightHandSide instanceof org.sosy_lab.cpachecker.cfa.ast.IASTExpression) {
                    return new IASTExpressionAssignmentStatement(fileLoc, leftHandSide, (org.sosy_lab.cpachecker.cfa.ast.IASTExpression)rightHandSide);
                }
                if (rightHandSide instanceof IASTFunctionCallExpression) {
                    return new IASTFunctionCallAssignmentStatement(fileLoc, leftHandSide, (IASTFunctionCallExpression)rightHandSide);
                }
                if (rightHandSide instanceof IASTAssignment) {
                    this.sideAssigment.add(rightHandSide);
                    return new IASTExpressionAssignmentStatement(fileLoc, leftHandSide, ((IASTAssignment)((Object)rightHandSide)).getLeftHandSide());
                }
                throw new CFAGenerationRuntimeException("Expression is not free of side-effects", (org.eclipse.cdt.core.dom.ast.IASTNode)e);
            }
            org.sosy_lab.cpachecker.cfa.ast.IASTExpression rightHandSide = this.convertExpressionWithoutSideEffects(e.getOperand2());
            org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression exp = new org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression(fileLoc, type, leftHandSide, rightHandSide, op);
            return new IASTExpressionAssignmentStatement(fileLoc, leftHandSide, exp);
        }
        org.sosy_lab.cpachecker.cfa.ast.IASTExpression rightHandSide = this.convertExpressionWithoutSideEffects(e.getOperand2());
        return new org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression(fileLoc, type, leftHandSide, rightHandSide, op);
    }

    private Pair<IASTBinaryExpression.BinaryOperator, Boolean> convertBinaryOperator(IASTBinaryExpression e) {
        IASTBinaryExpression.BinaryOperator operator;
        boolean isAssign = false;
        switch (e.getOperator()) {
            case 1: {
                operator = IASTBinaryExpression.BinaryOperator.MULTIPLY;
                break;
            }
            case 2: {
                operator = IASTBinaryExpression.BinaryOperator.DIVIDE;
                break;
            }
            case 3: {
                operator = IASTBinaryExpression.BinaryOperator.MODULO;
                break;
            }
            case 4: {
                operator = IASTBinaryExpression.BinaryOperator.PLUS;
                break;
            }
            case 5: {
                operator = IASTBinaryExpression.BinaryOperator.MINUS;
                break;
            }
            case 6: {
                operator = IASTBinaryExpression.BinaryOperator.SHIFT_LEFT;
                break;
            }
            case 7: {
                operator = IASTBinaryExpression.BinaryOperator.SHIFT_RIGHT;
                break;
            }
            case 8: {
                operator = IASTBinaryExpression.BinaryOperator.LESS_THAN;
                break;
            }
            case 9: {
                operator = IASTBinaryExpression.BinaryOperator.GREATER_THAN;
                break;
            }
            case 10: {
                operator = IASTBinaryExpression.BinaryOperator.LESS_EQUAL;
                break;
            }
            case 11: {
                operator = IASTBinaryExpression.BinaryOperator.GREATER_EQUAL;
                break;
            }
            case 12: {
                operator = IASTBinaryExpression.BinaryOperator.BINARY_AND;
                break;
            }
            case 13: {
                operator = IASTBinaryExpression.BinaryOperator.BINARY_XOR;
                break;
            }
            case 14: {
                operator = IASTBinaryExpression.BinaryOperator.BINARY_OR;
                break;
            }
            case 15: {
                operator = IASTBinaryExpression.BinaryOperator.LOGICAL_AND;
                break;
            }
            case 16: {
                operator = IASTBinaryExpression.BinaryOperator.LOGICAL_OR;
                break;
            }
            case 17: {
                operator = null;
                isAssign = true;
                break;
            }
            case 18: {
                operator = IASTBinaryExpression.BinaryOperator.MULTIPLY;
                isAssign = true;
                break;
            }
            case 19: {
                operator = IASTBinaryExpression.BinaryOperator.DIVIDE;
                isAssign = true;
                break;
            }
            case 20: {
                operator = IASTBinaryExpression.BinaryOperator.MODULO;
                isAssign = true;
                break;
            }
            case 21: {
                operator = IASTBinaryExpression.BinaryOperator.PLUS;
                isAssign = true;
                break;
            }
            case 22: {
                operator = IASTBinaryExpression.BinaryOperator.MINUS;
                isAssign = true;
                break;
            }
            case 23: {
                operator = IASTBinaryExpression.BinaryOperator.SHIFT_LEFT;
                isAssign = true;
                break;
            }
            case 24: {
                operator = IASTBinaryExpression.BinaryOperator.SHIFT_RIGHT;
                isAssign = true;
                break;
            }
            case 25: {
                operator = IASTBinaryExpression.BinaryOperator.BINARY_AND;
                isAssign = true;
                break;
            }
            case 26: {
                operator = IASTBinaryExpression.BinaryOperator.BINARY_XOR;
                isAssign = true;
                break;
            }
            case 27: {
                operator = IASTBinaryExpression.BinaryOperator.BINARY_OR;
                isAssign = true;
                break;
            }
            case 28: {
                operator = IASTBinaryExpression.BinaryOperator.EQUALS;
                break;
            }
            case 29: {
                operator = IASTBinaryExpression.BinaryOperator.NOT_EQUALS;
                break;
            }
            default: {
                throw new CFAGenerationRuntimeException("Unknown binary operator", (org.eclipse.cdt.core.dom.ast.IASTNode)e);
            }
        }
        return Pair.of((Object)((Object)operator), (Object)isAssign);
    }

    private IASTNode convert(IASTCastExpression e) {
        if (this.ignoreCasts) {
            return this.convertExpressionWithSideEffects(e.getOperand());
        }
        return new org.sosy_lab.cpachecker.cfa.ast.IASTCastExpression(this.convert(e.getFileLocation()), this.convert(e.getExpressionType()), this.convertExpressionWithoutSideEffects(e.getOperand()), this.convert(e.getTypeId()));
    }

    private IASTFieldReference convert(org.eclipse.cdt.core.dom.ast.IASTFieldReference e) {
        return new IASTFieldReference(this.convert(e.getFileLocation()), this.convert(e.getExpressionType()), this.convert(e.getFieldName()), this.convertExpressionWithoutSideEffects(e.getFieldOwner()), e.isPointerDereference());
    }

    private IASTFunctionCallExpression convert(org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression e) {
        List<Object> params;
        IASTExpression p = e.getParameterExpression();
        if (p instanceof IASTExpressionList) {
            params = this.convert((IASTExpressionList)p);
        } else {
            params = new ArrayList();
            if (p != null) {
                params.add(this.convertExpressionWithoutSideEffects(p));
            }
        }
        org.sosy_lab.cpachecker.cfa.ast.IASTExpression functionName = this.convertExpressionWithoutSideEffects(e.getFunctionNameExpression());
        IASTSimpleDeclaration declaration = null;
        if (functionName instanceof IASTIdExpression) {
            IASTIdExpression idExpression = (IASTIdExpression)functionName;
            String name = idExpression.getName();
            declaration = this.scope.lookupFunction(name);
            if (idExpression.getDeclaration() != null) {
                functionName = new IASTIdExpression(idExpression.getFileLocation(), idExpression.getExpressionType(), name, declaration);
            }
        }
        return new IASTFunctionCallExpression(this.convert(e.getFileLocation()), this.convert(e.getExpressionType()), functionName, params, declaration);
    }

    private List<org.sosy_lab.cpachecker.cfa.ast.IASTExpression> convert(IASTExpressionList es) {
        ArrayList<org.sosy_lab.cpachecker.cfa.ast.IASTExpression> result = new ArrayList<org.sosy_lab.cpachecker.cfa.ast.IASTExpression>(es.getExpressions().length);
        for (IASTExpression expression : es.getExpressions()) {
            result.add(this.convertExpressionWithoutSideEffects(expression));
        }
        return result;
    }

    private IASTIdExpression convert(org.eclipse.cdt.core.dom.ast.IASTIdExpression e) {
        String name = this.convert(e.getName());
        IASTSimpleDeclaration declaration = this.scope.lookupVariable(name);
        if (declaration != null) {
            name = declaration.getName();
        }
        return new IASTIdExpression(this.convert(e.getFileLocation()), this.convert(e.getExpressionType()), name, declaration);
    }

    private org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression convert(IASTLiteralExpression e) {
        org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation fileLoc = this.convert(e.getFileLocation());
        org.sosy_lab.cpachecker.cfa.ast.IType type = this.convert(e.getExpressionType());
        String valueStr = String.valueOf(e.getValue());
        switch (e.getKind()) {
            case 2: {
                return new IASTCharLiteralExpression(fileLoc, type, this.parseCharacterLiteral(valueStr, (org.eclipse.cdt.core.dom.ast.IASTNode)e));
            }
            case 0: {
                return new IASTIntegerLiteralExpression(fileLoc, type, this.parseIntegerLiteral(valueStr, (org.eclipse.cdt.core.dom.ast.IASTNode)e));
            }
            case 1: {
                BigDecimal value;
                try {
                    value = new BigDecimal(valueStr);
                }
                catch (NumberFormatException nfe1) {
                    try {
                        value = BigDecimal.valueOf(Double.parseDouble(valueStr));
                    }
                    catch (NumberFormatException nfe2) {
                        throw new CFAGenerationRuntimeException("illegal floating point literal", (org.eclipse.cdt.core.dom.ast.IASTNode)e);
                    }
                }
                return new IASTFloatLiteralExpression(fileLoc, type, value);
            }
            case 3: {
                return new IASTStringLiteralExpression(fileLoc, type, valueStr);
            }
        }
        throw new CFAGenerationRuntimeException("Unknown literal", (org.eclipse.cdt.core.dom.ast.IASTNode)e);
    }

    char parseCharacterLiteral(String s, org.eclipse.cdt.core.dom.ast.IASTNode e) {
        int result;
        ASTConverter.check(s.length() >= 3, "invalid character literal (too short)", e);
        ASTConverter.check(s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'', "character literal without quotation marks", e);
        s = s.substring(1, s.length() - 1);
        if (s.length() == 1) {
            result = s.charAt(0);
            ASTConverter.check(result != 92, "invalid quoting sequence", e);
        } else {
            ASTConverter.check(s.charAt(0) == '\\', "character literal too long", e);
            s = s.substring(1);
            ASTConverter.check(s.length() >= 1, "invalid quoting sequence", e);
            char c = s.charAt(0);
            if (c == 'x' || c == 'X') {
                ASTConverter.check((s = s.substring(1)).length() > 0 && s.length() <= 3, "character literal with illegal hex number", e);
                try {
                    result = (char)Integer.parseInt(s, 16);
                    ASTConverter.check(result <= 255, "hex escape sequence out of range", e);
                }
                catch (NumberFormatException _) {
                    throw new CFAGenerationRuntimeException("character literal with illegal hex number", e);
                }
            } else if (Character.isDigit(c)) {
                ASTConverter.check(s.length() <= 3, "character literal with illegal octal number", e);
                try {
                    result = (char)Integer.parseInt(s, 8);
                    ASTConverter.check(result <= 255, "octal escape sequence out of range", e);
                }
                catch (NumberFormatException _) {
                    throw new CFAGenerationRuntimeException("character literal with illegal octal number", e);
                }
            } else {
                ASTConverter.check(s.length() == 1, "character literal too long", e);
                switch (c) {
                    case 'b': {
                        result = 8;
                        break;
                    }
                    case 't': {
                        result = 9;
                        break;
                    }
                    case 'v': {
                        result = 11;
                        break;
                    }
                    case 'n': {
                        result = 10;
                        break;
                    }
                    case 'f': {
                        result = 12;
                        break;
                    }
                    case 'r': {
                        result = 13;
                        break;
                    }
                    case '\"': {
                        result = 34;
                        break;
                    }
                    case '\'': {
                        result = 39;
                        break;
                    }
                    case '\\': {
                        result = 92;
                        break;
                    }
                    default: {
                        throw new CFAGenerationRuntimeException("unknown character literal", e);
                    }
                }
            }
        }
        return (char)result;
    }

    BigInteger parseIntegerLiteral(String s, org.eclipse.cdt.core.dom.ast.IASTNode e) {
        BigInteger result;
        int last = s.length() - 1;
        int bits = 32;
        boolean signed = true;
        if (s.charAt(last) == 'L' || s.charAt(last) == 'l') {
            --last;
        }
        if (s.charAt(last) == 'L' || s.charAt(last) == 'l') {
            --last;
            bits = 64;
        }
        if (s.charAt(last) == 'U' || s.charAt(last) == 'u') {
            --last;
            signed = false;
        }
        s = s.substring(0, last + 1);
        try {
            if (s.startsWith("0x") || s.startsWith("0X")) {
                s = s.substring(2);
                result = new BigInteger(s, 16);
            } else {
                result = s.startsWith("0") ? new BigInteger(s, 8) : new BigInteger(s, 10);
            }
        }
        catch (NumberFormatException _) {
            throw new CFAGenerationRuntimeException("invalid number", e);
        }
        ASTConverter.check(result.compareTo(BigInteger.ZERO) >= 0, "invalid number", e);
        BigInteger mask = BigInteger.ZERO.setBit(bits).subtract(BigInteger.ONE);
        result = result.and(mask);
        assert (result.bitLength() <= bits);
        if (signed && result.testBit(bits - 1)) {
            result = result.clearBit(bits - 1);
            BigInteger minValue = BigInteger.ZERO.setBit(bits - 1).negate();
            result = minValue.add(result);
        }
        return result;
    }

    private IASTNode convert(IASTUnaryExpression e) {
        org.sosy_lab.cpachecker.cfa.ast.IASTExpression operand = this.convertExpressionWithoutSideEffects(e.getOperand());
        if (e.getOperator() == 11) {
            return operand;
        }
        org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation fileLoc = this.convert(e.getFileLocation());
        org.sosy_lab.cpachecker.cfa.ast.IType type = this.convert(e.getExpressionType());
        switch (e.getOperator()) {
            case 0: 
            case 1: {
                IASTBinaryExpression.BinaryOperator preOp;
                switch (e.getOperator()) {
                    case 0: {
                        preOp = IASTBinaryExpression.BinaryOperator.PLUS;
                        break;
                    }
                    case 1: {
                        preOp = IASTBinaryExpression.BinaryOperator.MINUS;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                IASTIntegerLiteralExpression one = new IASTIntegerLiteralExpression(fileLoc, type, BigInteger.ONE);
                org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression preExp = new org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression(fileLoc, type, operand, one, preOp);
                return new IASTExpressionAssignmentStatement(fileLoc, operand, preExp);
            }
            case 9: 
            case 10: {
                IASTBinaryExpression.BinaryOperator postOp;
                switch (e.getOperator()) {
                    case 9: {
                        postOp = IASTBinaryExpression.BinaryOperator.PLUS;
                        break;
                    }
                    case 10: {
                        postOp = IASTBinaryExpression.BinaryOperator.MINUS;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                if (e.getParent() instanceof IASTExpression) {
                    return this.addSideAssignmentsForUnaryExpressions(operand, fileLoc, type, postOp);
                }
                IASTIntegerLiteralExpression postOne = new IASTIntegerLiteralExpression(fileLoc, type, BigInteger.ONE);
                org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression postExp = new org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression(fileLoc, type, operand, postOne, postOp);
                return new IASTExpressionAssignmentStatement(fileLoc, operand, postExp);
            }
        }
        return new org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression(fileLoc, type, operand, this.convertUnaryOperator(e));
    }

    private IASTIdExpression addSideAssignmentsForUnaryExpressions(org.sosy_lab.cpachecker.cfa.ast.IASTExpression exp, org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation fileLoc, org.sosy_lab.cpachecker.cfa.ast.IType type, IASTBinaryExpression.BinaryOperator op) {
        String name = "__CPAchecker_TMP_";
        int i = 0;
        while (this.scope.variableNameInUse(name + i, name + i)) {
            ++i;
        }
        name = name + i;
        IASTVariableDeclaration decl = new IASTVariableDeclaration(fileLoc, false, StorageClass.AUTO, type, name, name, null);
        this.scope.registerDeclaration(decl);
        this.sideAssigment.add(decl);
        IASTIdExpression tmp = new IASTIdExpression(fileLoc, type, name, decl);
        this.sideAssigment.add(new IASTExpressionAssignmentStatement(fileLoc, tmp, exp));
        IASTIntegerLiteralExpression one = new IASTIntegerLiteralExpression(fileLoc, type, BigInteger.ONE);
        org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression postExp = new org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression(fileLoc, type, exp, one, op);
        this.sideAssigment.add(new IASTExpressionAssignmentStatement(fileLoc, exp, postExp));
        return tmp;
    }

    private IASTUnaryExpression.UnaryOperator convertUnaryOperator(IASTUnaryExpression e) {
        switch (e.getOperator()) {
            case 5: {
                return IASTUnaryExpression.UnaryOperator.AMPER;
            }
            case 3: {
                return IASTUnaryExpression.UnaryOperator.MINUS;
            }
            case 7: {
                return IASTUnaryExpression.UnaryOperator.NOT;
            }
            case 2: {
                return IASTUnaryExpression.UnaryOperator.PLUS;
            }
            case 8: {
                return IASTUnaryExpression.UnaryOperator.SIZEOF;
            }
            case 4: {
                return IASTUnaryExpression.UnaryOperator.STAR;
            }
            case 6: {
                return IASTUnaryExpression.UnaryOperator.TILDE;
            }
        }
        throw new CFAGenerationRuntimeException("Unknown unary operator", (org.eclipse.cdt.core.dom.ast.IASTNode)e);
    }

    private IASTTypeIdExpression convert(org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression e) {
        return new IASTTypeIdExpression(this.convert(e.getFileLocation()), this.convert(e.getExpressionType()), this.convertTypeIdOperator(e), this.convert(e.getTypeId()));
    }

    private IASTTypeIdExpression.TypeIdOperator convertTypeIdOperator(org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression e) {
        switch (e.getOperator()) {
            case 2: {
                return IASTTypeIdExpression.TypeIdOperator.ALIGNOF;
            }
            case 0: {
                return IASTTypeIdExpression.TypeIdOperator.SIZEOF;
            }
            case 1: {
                return IASTTypeIdExpression.TypeIdOperator.TYPEID;
            }
            case 3: {
                return IASTTypeIdExpression.TypeIdOperator.TYPEOF;
            }
        }
        throw new CFAGenerationRuntimeException("Unknown type id operator", (org.eclipse.cdt.core.dom.ast.IASTNode)e);
    }

    public IASTNode convert(IASTStatement s) {
        if (s instanceof org.eclipse.cdt.core.dom.ast.IASTExpressionStatement) {
            return this.convert((org.eclipse.cdt.core.dom.ast.IASTExpressionStatement)s);
        }
        if (s instanceof IASTReturnStatement) {
            return this.convert((IASTReturnStatement)s);
        }
        if (s instanceof IASTProblemStatement) {
            throw new CFAGenerationRuntimeException((IASTProblemStatement)s);
        }
        throw new CFAGenerationRuntimeException("unknown statement: " + s.getClass(), (org.eclipse.cdt.core.dom.ast.IASTNode)s);
    }

    public org.sosy_lab.cpachecker.cfa.ast.IASTStatement convert(org.eclipse.cdt.core.dom.ast.IASTExpressionStatement s) {
        IASTNode node = this.convertExpressionWithSideEffects(s.getExpression());
        if (node instanceof IASTExpressionAssignmentStatement) {
            return (IASTExpressionAssignmentStatement)node;
        }
        if (node instanceof IASTFunctionCallAssignmentStatement) {
            return (IASTFunctionCallAssignmentStatement)node;
        }
        if (node instanceof IASTFunctionCallExpression) {
            return new IASTFunctionCallStatement(this.convert(s.getFileLocation()), (IASTFunctionCallExpression)node);
        }
        if (node instanceof org.sosy_lab.cpachecker.cfa.ast.IASTExpression) {
            return new IASTExpressionStatement(this.convert(s.getFileLocation()), (org.sosy_lab.cpachecker.cfa.ast.IASTExpression)node);
        }
        throw new AssertionError();
    }

    public org.sosy_lab.cpachecker.cfa.ast.IASTReturnStatement convert(IASTReturnStatement s) {
        return new org.sosy_lab.cpachecker.cfa.ast.IASTReturnStatement(this.convert(s.getFileLocation()), this.convertExpressionWithoutSideEffects(s.getReturnValue()));
    }

    public IASTFunctionDeclaration convert(IASTFunctionDefinition f) {
        Pair<StorageClass, ? extends org.sosy_lab.cpachecker.cfa.ast.IType> specifier = this.convert(f.getDeclSpecifier());
        StorageClass storageClass = (StorageClass)((Object)specifier.getFirst());
        if (storageClass != StorageClass.AUTO && storageClass != StorageClass.STATIC && storageClass != StorageClass.EXTERN) {
            throw new CFAGenerationRuntimeException("Unsupported storage class for function definition", (org.eclipse.cdt.core.dom.ast.IASTNode)f);
        }
        Triple<org.sosy_lab.cpachecker.cfa.ast.IType, IASTInitializer, String> declarator = this.convert(f.getDeclarator(), (org.sosy_lab.cpachecker.cfa.ast.IType)specifier.getSecond());
        if (!(declarator.getFirst() instanceof IASTFunctionTypeSpecifier)) {
            throw new CFAGenerationRuntimeException("Unsupported nested declarator for function definition", (org.eclipse.cdt.core.dom.ast.IASTNode)f);
        }
        if (declarator.getSecond() != null) {
            throw new CFAGenerationRuntimeException("Unsupported initializer for function definition", (org.eclipse.cdt.core.dom.ast.IASTNode)f);
        }
        if (declarator.getThird() == null) {
            throw new CFAGenerationRuntimeException("Missing name for function definition", (org.eclipse.cdt.core.dom.ast.IASTNode)f);
        }
        IASTFunctionTypeSpecifier declSpec = (IASTFunctionTypeSpecifier)declarator.getFirst();
        String name = (String)declarator.getThird();
        org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation fileLoc = this.convert(f.getFileLocation());
        return new IASTFunctionDeclaration(fileLoc, declSpec, name);
    }

    public List<IASTDeclaration> convert(org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration d) {
        List<IASTDeclaration> result;
        org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation fileLoc = this.convert(d.getFileLocation());
        Pair<StorageClass, ? extends org.sosy_lab.cpachecker.cfa.ast.IType> specifier = this.convert(d.getDeclSpecifier());
        StorageClass storageClass = (StorageClass)((Object)specifier.getFirst());
        org.sosy_lab.cpachecker.cfa.ast.IType type = (org.sosy_lab.cpachecker.cfa.ast.IType)specifier.getSecond();
        IASTDeclarator[] declarators = d.getDeclarators();
        if (declarators == null || declarators.length == 0) {
            IASTDeclaration newD = this.createDeclaration(fileLoc, storageClass, type, null);
            result = Collections.singletonList(newD);
        } else if (declarators.length == 1) {
            IASTDeclaration newD = this.createDeclaration(fileLoc, storageClass, type, declarators[0]);
            result = Collections.singletonList(newD);
        } else {
            result = new ArrayList<IASTDeclaration>(declarators.length);
            for (IASTDeclarator c : declarators) {
                result.add(this.createDeclaration(fileLoc, storageClass, type, c));
            }
        }
        return result;
    }

    private IASTDeclaration createDeclaration(org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation fileLoc, StorageClass storageClass, org.sosy_lab.cpachecker.cfa.ast.IType type, IASTDeclarator d) {
        boolean isGlobal = this.scope.isGlobalScope();
        if (d != null) {
            org.sosy_lab.cpachecker.cfa.ast.IASTLiteralExpression init;
            Triple<org.sosy_lab.cpachecker.cfa.ast.IType, IASTInitializer, String> declarator = this.convert(d, type);
            type = (org.sosy_lab.cpachecker.cfa.ast.IType)declarator.getFirst();
            IASTInitializer initializer = (IASTInitializer)declarator.getSecond();
            String name = (String)declarator.getThird();
            if (name == null) {
                throw new CFAGenerationRuntimeException("Declaration without name", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
            }
            if (storageClass == StorageClass.TYPEDEF) {
                if (initializer != null) {
                    throw new CFAGenerationRuntimeException("Typedef with initializer", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
                }
                return new IASTTypeDefDeclaration(fileLoc, isGlobal, type, name);
            }
            if (type instanceof IASTFunctionTypeSpecifier) {
                if (initializer != null) {
                    throw new CFAGenerationRuntimeException("Function definition with initializer", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
                }
                if (!isGlobal) {
                    throw new CFAGenerationRuntimeException("Non-global function definition", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
                }
                return new IASTFunctionDeclaration(fileLoc, (IASTFunctionTypeSpecifier)type, name);
            }
            if (storageClass == StorageClass.EXTERN && initializer != null) {
                throw new CFAGenerationRuntimeException("Extern declarations cannot have initializers", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
            }
            if (initializer == null && this.scope.isGlobalScope() && storageClass != StorageClass.EXTERN && (init = Defaults.forType(type, fileLoc)) != null) {
                initializer = new org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression(fileLoc, init);
            }
            String origName = name;
            if (storageClass == StorageClass.STATIC) {
                if (!isGlobal) {
                    isGlobal = true;
                    name = "static__" + this.scope.getCurrentFunctionName() + "__" + name;
                }
                storageClass = StorageClass.AUTO;
            }
            if (this.scope.variableNameInUse(name, name)) {
                String sep = "__";
                int index = 1;
                while (this.scope.variableNameInUse(name + sep + index, origName)) {
                    ++index;
                }
                name = name + sep + index;
            }
            return new IASTVariableDeclaration(fileLoc, isGlobal, storageClass, type, name, origName, initializer);
        }
        if (type instanceof IASTCompositeTypeSpecifier || type instanceof IASTEnumerationSpecifier || type instanceof org.sosy_lab.cpachecker.cfa.ast.IASTElaboratedTypeSpecifier) {
            return new IASTComplexTypeDeclaration(fileLoc, isGlobal, type);
        }
        throw new CFAGenerationRuntimeException("Declaration without declarator, but type is unknown: " + type.toASTString(""));
    }

    private List<IASTCompositeTypeSpecifier.IASTCompositeTypeMemberDeclaration> convertDeclarationInCompositeType(org.eclipse.cdt.core.dom.ast.IASTDeclaration d) {
        List<IASTCompositeTypeSpecifier.IASTCompositeTypeMemberDeclaration> result;
        if (d instanceof IASTProblemDeclaration) {
            throw new CFAGenerationRuntimeException((IASTProblemDeclaration)d);
        }
        if (!(d instanceof org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration)) {
            throw new CFAGenerationRuntimeException("unknown declaration type " + d.getClass().getSimpleName(), (org.eclipse.cdt.core.dom.ast.IASTNode)d);
        }
        org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration sd = (org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration)d;
        org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation fileLoc = this.convert(d.getFileLocation());
        Pair<StorageClass, ? extends org.sosy_lab.cpachecker.cfa.ast.IType> specifier = this.convert(sd.getDeclSpecifier());
        if (specifier.getFirst() != StorageClass.AUTO) {
            throw new CFAGenerationRuntimeException("Unsupported storage class inside composite type", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
        }
        org.sosy_lab.cpachecker.cfa.ast.IType type = (org.sosy_lab.cpachecker.cfa.ast.IType)specifier.getSecond();
        IASTDeclarator[] declarators = sd.getDeclarators();
        if (declarators == null || declarators.length == 0) {
            IASTCompositeTypeSpecifier.IASTCompositeTypeMemberDeclaration newD = this.createDeclarationForCompositeType(fileLoc, type, null);
            result = Collections.singletonList(newD);
        } else if (declarators.length == 1) {
            IASTCompositeTypeSpecifier.IASTCompositeTypeMemberDeclaration newD = this.createDeclarationForCompositeType(fileLoc, type, declarators[0]);
            result = Collections.singletonList(newD);
        } else {
            result = new ArrayList<IASTCompositeTypeSpecifier.IASTCompositeTypeMemberDeclaration>(declarators.length);
            for (IASTDeclarator c : declarators) {
                result.add(this.createDeclarationForCompositeType(fileLoc, type, c));
            }
        }
        return result;
    }

    private IASTCompositeTypeSpecifier.IASTCompositeTypeMemberDeclaration createDeclarationForCompositeType(org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation fileLoc, org.sosy_lab.cpachecker.cfa.ast.IType type, IASTDeclarator d) {
        String name = null;
        if (d != null) {
            Triple<org.sosy_lab.cpachecker.cfa.ast.IType, IASTInitializer, String> declarator = this.convert(d, type);
            if (declarator.getSecond() != null) {
                throw new CFAGenerationRuntimeException("Unsupported initializer inside composite type", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
            }
            type = (org.sosy_lab.cpachecker.cfa.ast.IType)declarator.getFirst();
            name = (String)declarator.getThird();
        }
        return new IASTCompositeTypeSpecifier.IASTCompositeTypeMemberDeclaration(fileLoc, type, name);
    }

    private Triple<org.sosy_lab.cpachecker.cfa.ast.IType, IASTInitializer, String> convert(IASTDeclarator d, org.sosy_lab.cpachecker.cfa.ast.IType specifier) {
        if (d instanceof IASTFunctionDeclarator) {
            return this.convert((IASTFunctionDeclarator)d, specifier);
        }
        ArrayList modifiers = Lists.newArrayListWithExpectedSize((int)1);
        IASTInitializer initializer = null;
        String name = null;
        for (IASTDeclarator currentDecl = d; currentDecl != null; currentDecl = currentDecl.getNestedDeclarator()) {
            if (currentDecl instanceof IASTFunctionDeclarator) {
                throw new CFAGenerationRuntimeException("Unsupported declaration nested function declarations", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
            }
            modifiers.addAll(Arrays.asList(currentDecl.getPointerOperators()));
            if (currentDecl instanceof IASTArrayDeclarator) {
                modifiers.addAll(Arrays.asList(((IASTArrayDeclarator)currentDecl).getArrayModifiers()));
            }
            if (currentDecl.getInitializer() != null) {
                if (initializer != null) {
                    throw new CFAGenerationRuntimeException("Unsupported declaration with two initializers", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
                }
                initializer = this.convert(currentDecl.getInitializer());
            }
            if (currentDecl.getName().toString().isEmpty()) continue;
            if (name != null) {
                throw new CFAGenerationRuntimeException("Unsupported declaration with two names", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
            }
            name = this.convert(currentDecl.getName());
        }
        name = Strings.nullToEmpty(name);
        org.sosy_lab.cpachecker.cfa.ast.IType type = specifier;
        for (org.eclipse.cdt.core.dom.ast.IASTNode modifier : modifiers) {
            if (modifier instanceof IASTArrayModifier) {
                type = this.convert((IASTArrayModifier)modifier, type);
                continue;
            }
            if (modifier instanceof IASTPointerOperator) {
                type = this.convert((IASTPointerOperator)modifier, type);
                continue;
            }
            assert (false);
        }
        return Triple.of((Object)type, initializer, (Object)name);
    }

    private org.sosy_lab.cpachecker.cfa.ast.IType convertPointerOperators(IASTPointerOperator[] ps, org.sosy_lab.cpachecker.cfa.ast.IType type) {
        for (IASTPointerOperator p : ps) {
            type = this.convert(p, type);
        }
        return type;
    }

    private IASTPointerTypeSpecifier convert(IASTPointerOperator po, org.sosy_lab.cpachecker.cfa.ast.IType type) {
        if (po instanceof IASTPointer) {
            IASTPointer p = (IASTPointer)po;
            return new IASTPointerTypeSpecifier(p.isConst(), p.isVolatile(), type);
        }
        throw new CFAGenerationRuntimeException("Unknown pointer operator", (org.eclipse.cdt.core.dom.ast.IASTNode)po);
    }

    private org.sosy_lab.cpachecker.cfa.ast.IType convert(IASTArrayModifier am, org.sosy_lab.cpachecker.cfa.ast.IType type) {
        if (am instanceof ICASTArrayModifier) {
            ICASTArrayModifier a = (ICASTArrayModifier)am;
            return new IASTArrayTypeSpecifier(a.isConst(), a.isVolatile(), type, this.convertExpressionWithoutSideEffects(a.getConstantExpression()));
        }
        throw new CFAGenerationRuntimeException("Unknown array modifier", (org.eclipse.cdt.core.dom.ast.IASTNode)am);
    }

    private Triple<org.sosy_lab.cpachecker.cfa.ast.IType, IASTInitializer, String> convert(IASTFunctionDeclarator d, org.sosy_lab.cpachecker.cfa.ast.IType returnType) {
        String name;
        IASTFunctionTypeSpecifier fType;
        if (!(d instanceof IASTStandardFunctionDeclarator)) {
            throw new CFAGenerationRuntimeException("Unknown non-standard function definition", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
        }
        IASTStandardFunctionDeclarator sd = (IASTStandardFunctionDeclarator)d;
        returnType = this.convertPointerOperators(d.getPointerOperators(), returnType);
        List<IASTParameterDeclaration> paramsList = this.convert(sd.getParameters());
        org.sosy_lab.cpachecker.cfa.ast.IType type = fType = new IASTFunctionTypeSpecifier(false, false, returnType, paramsList, sd.takesVarArgs());
        if (d.getNestedDeclarator() != null) {
            Triple<org.sosy_lab.cpachecker.cfa.ast.IType, IASTInitializer, String> nestedDeclarator = this.convert(d.getNestedDeclarator(), type);
            assert (d.getName().getRawSignature().isEmpty()) : d;
            assert (nestedDeclarator.getSecond() == null);
            type = (org.sosy_lab.cpachecker.cfa.ast.IType)nestedDeclarator.getFirst();
            name = (String)nestedDeclarator.getThird();
        } else {
            name = this.convert(d.getName());
        }
        fType.setName(name);
        return Triple.of((Object)type, (Object)this.convert(d.getInitializer()), (Object)name);
    }

    private Pair<StorageClass, ? extends org.sosy_lab.cpachecker.cfa.ast.IType> convert(IASTDeclSpecifier d) {
        StorageClass sc = this.convertStorageClass(d);
        if (d instanceof org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier) {
            return Pair.of((Object)((Object)sc), (Object)this.convert((org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier)d));
        }
        if (d instanceof IASTElaboratedTypeSpecifier) {
            return Pair.of((Object)((Object)sc), (Object)this.convert((IASTElaboratedTypeSpecifier)d));
        }
        if (d instanceof org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier) {
            return Pair.of((Object)((Object)sc), (Object)this.convert((org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier)d));
        }
        if (d instanceof IASTNamedTypeSpecifier) {
            return Pair.of((Object)((Object)sc), (Object)this.convert((IASTNamedTypeSpecifier)d));
        }
        if (d instanceof IASTSimpleDeclSpecifier) {
            return Pair.of((Object)((Object)sc), (Object)this.convert((IASTSimpleDeclSpecifier)d));
        }
        throw new CFAGenerationRuntimeException("unknown declSpecifier", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
    }

    private StorageClass convertStorageClass(IASTDeclSpecifier d) {
        switch (d.getStorageClass()) {
            case 0: 
            case 4: 
            case 5: {
                return StorageClass.AUTO;
            }
            case 3: {
                return StorageClass.STATIC;
            }
            case 2: {
                return StorageClass.EXTERN;
            }
            case 1: {
                return StorageClass.TYPEDEF;
            }
        }
        throw new CFAGenerationRuntimeException("Unsupported storage class", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
    }

    private IASTCompositeTypeSpecifier convert(org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier d) {
        ArrayList<IASTCompositeTypeSpecifier.IASTCompositeTypeMemberDeclaration> list = new ArrayList<IASTCompositeTypeSpecifier.IASTCompositeTypeMemberDeclaration>(d.getMembers().length);
        for (org.eclipse.cdt.core.dom.ast.IASTDeclaration c : d.getMembers()) {
            List<IASTCompositeTypeSpecifier.IASTCompositeTypeMemberDeclaration> newCs = this.convertDeclarationInCompositeType(c);
            assert (!newCs.isEmpty());
            list.addAll(newCs);
        }
        return new IASTCompositeTypeSpecifier(d.isConst(), d.isVolatile(), d.getKey(), list, this.convert(d.getName()));
    }

    private org.sosy_lab.cpachecker.cfa.ast.IASTElaboratedTypeSpecifier convert(IASTElaboratedTypeSpecifier d) {
        IASTElaboratedTypeSpecifier.ElaboratedType type;
        switch (d.getKind()) {
            case 0: {
                type = IASTElaboratedTypeSpecifier.ElaboratedType.ENUM;
                break;
            }
            case 1: {
                type = IASTElaboratedTypeSpecifier.ElaboratedType.STRUCT;
                break;
            }
            case 2: {
                type = IASTElaboratedTypeSpecifier.ElaboratedType.UNION;
                break;
            }
            default: {
                throw new CFAGenerationRuntimeException("Unknown elaborated type", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
            }
        }
        return new org.sosy_lab.cpachecker.cfa.ast.IASTElaboratedTypeSpecifier(d.isConst(), d.isVolatile(), type, this.convert(d.getName()));
    }

    private IASTEnumerationSpecifier convert(org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier d) {
        ArrayList<IASTEnumerationSpecifier.IASTEnumerator> list = new ArrayList<IASTEnumerationSpecifier.IASTEnumerator>(d.getEnumerators().length);
        Long lastValue = -1L;
        for (IASTEnumerationSpecifier.IASTEnumerator c : d.getEnumerators()) {
            IASTEnumerationSpecifier.IASTEnumerator newC = this.convert(c, lastValue);
            list.add(newC);
            lastValue = newC.hasValue() ? Long.valueOf(newC.getValue()) : null;
        }
        return new IASTEnumerationSpecifier(d.isConst(), d.isVolatile(), list, this.convert(d.getName()));
    }

    private org.sosy_lab.cpachecker.cfa.ast.IASTNamedTypeSpecifier convert(IASTNamedTypeSpecifier d) {
        return new org.sosy_lab.cpachecker.cfa.ast.IASTNamedTypeSpecifier(d.isConst(), d.isVolatile(), this.convert(d.getName()));
    }

    private org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier convert(IASTSimpleDeclSpecifier d) {
        BasicType type;
        if (!(d instanceof ICASTSimpleDeclSpecifier)) {
            throw new CFAGenerationRuntimeException("Unsupported type", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
        }
        ICASTSimpleDeclSpecifier dd = (ICASTSimpleDeclSpecifier)d;
        switch (dd.getType()) {
            case 6: {
                type = BasicType.BOOL;
                break;
            }
            case 2: {
                type = BasicType.CHAR;
                break;
            }
            case 5: {
                type = BasicType.DOUBLE;
                break;
            }
            case 4: {
                type = BasicType.FLOAT;
                break;
            }
            case 3: {
                type = BasicType.INT;
                break;
            }
            case 0: {
                type = BasicType.UNSPECIFIED;
                break;
            }
            case 1: {
                type = BasicType.VOID;
                break;
            }
            default: {
                throw new CFAGenerationRuntimeException("Unknown basic type " + dd.getType(), (org.eclipse.cdt.core.dom.ast.IASTNode)d);
            }
        }
        if (dd.isShort() && dd.isLong() || dd.isShort() && dd.isLongLong() || dd.isLong() && dd.isLongLong() || dd.isSigned() && dd.isUnsigned()) {
            throw new CFAGenerationRuntimeException("Illegal combination of type identifiers", (org.eclipse.cdt.core.dom.ast.IASTNode)d);
        }
        return new org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier(dd.isConst(), dd.isVolatile(), type, dd.isLong(), dd.isShort(), dd.isSigned(), d.isUnsigned(), dd.isComplex(), dd.isImaginary(), dd.isLongLong());
    }

    private IASTEnumerationSpecifier.IASTEnumerator convert(IASTEnumerationSpecifier.IASTEnumerator e, Long lastValue) {
        Long value = null;
        if (e.getValue() == null && lastValue != null) {
            value = lastValue + 1L;
        } else {
            org.sosy_lab.cpachecker.cfa.ast.IASTExpression v = this.convertExpressionWithoutSideEffects(e.getValue());
            boolean negate = false;
            if (v instanceof org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression) {
                org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression u = (org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression)v;
                assert (u.getOperator() == IASTUnaryExpression.UnaryOperator.MINUS) : v;
                negate = true;
                v = u.getOperand();
            }
            if (v instanceof IASTIntegerLiteralExpression) {
                value = ((IASTIntegerLiteralExpression)v).asLong();
                if (negate) {
                    value = -value.longValue();
                }
            }
        }
        IASTEnumerationSpecifier.IASTEnumerator result = new IASTEnumerationSpecifier.IASTEnumerator(this.convert(e.getFileLocation()), this.convert(e.getName()), value);
        this.scope.registerDeclaration(result);
        return result;
    }

    private IASTInitializer convert(org.eclipse.cdt.core.dom.ast.IASTInitializer i) {
        if (i == null) {
            return null;
        }
        if (i instanceof IASTInitializerExpression) {
            return this.convert((IASTInitializerExpression)i);
        }
        if (i instanceof org.eclipse.cdt.core.dom.ast.IASTInitializerList) {
            return this.convert((org.eclipse.cdt.core.dom.ast.IASTInitializerList)i);
        }
        if (i instanceof IASTEqualsInitializer) {
            return this.convert((IASTEqualsInitializer)i);
        }
        if (i instanceof ICASTDesignatedInitializer) {
            this.logger.log(Level.INFO, new Object[]{"Ignoring initializer part in line", i.getFileLocation().getStartingLineNumber() + ":", i.getRawSignature()});
            return null;
        }
        throw new CFAGenerationRuntimeException("unknown initializer: " + i.getClass().getSimpleName(), (org.eclipse.cdt.core.dom.ast.IASTNode)i);
    }

    private org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression convert(IASTInitializerExpression i) {
        IASTNode initializer = this.convertExpressionWithSideEffects(i.getExpression());
        if (initializer != null && initializer instanceof IASTAssignment) {
            this.sideAssigment.add(initializer);
            return new org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression(this.convert(i.getFileLocation()), ((IASTAssignment)((Object)initializer)).getLeftHandSide());
        }
        if (initializer != null && !(initializer instanceof org.sosy_lab.cpachecker.cfa.ast.IASTExpression)) {
            throw new CFAGenerationRuntimeException("Initializer is not free of side-effects", (org.eclipse.cdt.core.dom.ast.IASTNode)i);
        }
        return new org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression(this.convert(i.getFileLocation()), (org.sosy_lab.cpachecker.cfa.ast.IASTExpression)initializer);
    }

    private IASTInitializerList convert(org.eclipse.cdt.core.dom.ast.IASTInitializerList iList) {
        ArrayList<IASTInitializer> initializerList = new ArrayList<IASTInitializer>(iList.getInitializers().length);
        for (org.eclipse.cdt.core.dom.ast.IASTInitializer i : iList.getInitializers()) {
            IASTInitializer newI = this.convert(i);
            if (newI == null) continue;
            initializerList.add(newI);
        }
        return new IASTInitializerList(this.convert(iList.getFileLocation()), initializerList);
    }

    private IASTInitializer convert(IASTEqualsInitializer i) {
        IASTInitializerClause ic = i.getInitializerClause();
        if (ic instanceof IASTExpression) {
            IASTExpression e = (IASTExpression)ic;
            IASTNode initializer = this.convertExpressionWithSideEffects(e);
            if (initializer != null && initializer instanceof IASTAssignment) {
                this.sideAssigment.add(initializer);
                return new org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression(this.convert(e.getFileLocation()), ((IASTAssignment)((Object)initializer)).getLeftHandSide());
            }
            if (initializer != null && initializer instanceof IASTFunctionCallExpression) {
                org.sosy_lab.cpachecker.cfa.ast.IASTExpression exp = this.addSideassignmentsForExpressionsWithoutSideEffects(initializer, e);
                return new org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression(this.convert(e.getFileLocation()), exp);
            }
            if (initializer != null && !(initializer instanceof org.sosy_lab.cpachecker.cfa.ast.IASTExpression)) {
                throw new CFAGenerationRuntimeException("Initializer is not free of side-effects", (org.eclipse.cdt.core.dom.ast.IASTNode)e);
            }
            return new org.sosy_lab.cpachecker.cfa.ast.IASTInitializerExpression(this.convert(ic.getFileLocation()), (org.sosy_lab.cpachecker.cfa.ast.IASTExpression)initializer);
        }
        if (ic instanceof org.eclipse.cdt.core.dom.ast.IASTInitializerList) {
            return this.convert((org.eclipse.cdt.core.dom.ast.IASTInitializerList)ic);
        }
        throw new CFAGenerationRuntimeException("unknown initializer: " + i.getClass().getSimpleName(), (org.eclipse.cdt.core.dom.ast.IASTNode)i);
    }

    private List<IASTParameterDeclaration> convert(org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration[] ps) {
        ArrayList<IASTParameterDeclaration> paramsList = new ArrayList<IASTParameterDeclaration>(ps.length);
        for (org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration c : ps) {
            if (!c.getRawSignature().equals("void")) {
                paramsList.add(this.convert(c));
                continue;
            }
            assert (ps.length == 1);
        }
        return paramsList;
    }

    private IASTParameterDeclaration convert(org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration p) {
        Pair<StorageClass, ? extends org.sosy_lab.cpachecker.cfa.ast.IType> specifier = this.convert(p.getDeclSpecifier());
        if (specifier.getFirst() != StorageClass.AUTO) {
            throw new CFAGenerationRuntimeException("Unsupported storage class for parameters", (org.eclipse.cdt.core.dom.ast.IASTNode)p);
        }
        Triple<org.sosy_lab.cpachecker.cfa.ast.IType, IASTInitializer, String> declarator = this.convert(p.getDeclarator(), (org.sosy_lab.cpachecker.cfa.ast.IType)specifier.getSecond());
        if (declarator.getSecond() != null) {
            throw new CFAGenerationRuntimeException("Unsupported initializer for parameters", (org.eclipse.cdt.core.dom.ast.IASTNode)p);
        }
        return new IASTParameterDeclaration(this.convert(p.getFileLocation()), (org.sosy_lab.cpachecker.cfa.ast.IType)declarator.getFirst(), (String)declarator.getThird());
    }

    public org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation convert(IASTFileLocation l) {
        if (l == null) {
            return null;
        }
        return new org.sosy_lab.cpachecker.cfa.ast.IASTFileLocation(l.getEndingLineNumber(), l.getFileName(), l.getNodeLength(), l.getNodeOffset(), l.getStartingLineNumber());
    }

    private String convert(IASTName n) {
        return n.toString();
    }

    private org.sosy_lab.cpachecker.cfa.ast.IType convert(IASTTypeId t) {
        Pair<StorageClass, ? extends org.sosy_lab.cpachecker.cfa.ast.IType> specifier = this.convert(t.getDeclSpecifier());
        if (specifier.getFirst() != StorageClass.AUTO) {
            throw new CFAGenerationRuntimeException("Unsupported storage class for type ids", (org.eclipse.cdt.core.dom.ast.IASTNode)t);
        }
        Triple<org.sosy_lab.cpachecker.cfa.ast.IType, IASTInitializer, String> declarator = this.convert(t.getAbstractDeclarator(), (org.sosy_lab.cpachecker.cfa.ast.IType)specifier.getSecond());
        if (declarator.getSecond() != null) {
            throw new CFAGenerationRuntimeException("Unsupported initializer for type ids", (org.eclipse.cdt.core.dom.ast.IASTNode)t);
        }
        if (declarator.getThird() != null && !((String)declarator.getThird()).trim().isEmpty()) {
            throw new CFAGenerationRuntimeException("Unsupported name for type ids", (org.eclipse.cdt.core.dom.ast.IASTNode)t);
        }
        return (org.sosy_lab.cpachecker.cfa.ast.IType)declarator.getFirst();
    }

    private org.sosy_lab.cpachecker.cfa.ast.IType convert(IType t) {
        if (t instanceof IBasicType) {
            return this.convert((IBasicType)t);
        }
        if (t instanceof IPointerType) {
            return this.convert((IPointerType)t);
        }
        if (t instanceof ITypedef) {
            return this.convert((ITypedef)t);
        }
        if (t instanceof IBinding) {
            return new IComplexType(((IBinding)t).getName());
        }
        return new DummyType(t.toString());
    }

    private org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier convert(IBasicType t) {
        try {
            if (t instanceof ICBasicType) {
                BasicType type;
                ICBasicType c = (ICBasicType)t;
                switch (t.getType()) {
                    case 6: {
                        type = BasicType.BOOL;
                        break;
                    }
                    case 2: {
                        type = BasicType.CHAR;
                        break;
                    }
                    case 5: {
                        type = BasicType.DOUBLE;
                        break;
                    }
                    case 4: {
                        type = BasicType.FLOAT;
                        break;
                    }
                    case 3: {
                        type = BasicType.INT;
                        break;
                    }
                    case 0: {
                        type = BasicType.UNSPECIFIED;
                        break;
                    }
                    case 1: {
                        type = BasicType.VOID;
                        break;
                    }
                    default: {
                        throw new CFAGenerationRuntimeException("Unknown basic type " + t.getType());
                    }
                }
                if (c.isShort() && c.isLong() || c.isShort() && c.isLongLong() || c.isLong() && c.isLongLong() || c.isSigned() && c.isUnsigned()) {
                    throw new CFAGenerationRuntimeException("Illegal combination of type identifiers");
                }
                return new org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier(false, false, type, c.isLong(), c.isShort(), c.isSigned(), c.isUnsigned(), c.isComplex(), c.isImaginary(), c.isLongLong());
            }
            if (t.getType() == 1) {
                return new org.sosy_lab.cpachecker.cfa.ast.IASTSimpleDeclSpecifier(false, false, BasicType.VOID, t.isLong(), t.isShort(), t.isSigned(), t.isUnsigned(), false, false, false);
            }
            throw new CFAGenerationRuntimeException("Unknown type " + t.toString());
        }
        catch (DOMException e) {
            throw new CFAGenerationRuntimeException(e);
        }
    }

    private IASTPointerTypeSpecifier convert(IPointerType t) {
        try {
            return new IASTPointerTypeSpecifier(t.isConst(), t.isVolatile(), this.convert(this.getType(t)));
        }
        catch (DOMException e) {
            throw new CFAGenerationRuntimeException(e);
        }
    }

    private IType getType(IPointerType t) throws DOMException {
        return t.getType();
    }

    private org.sosy_lab.cpachecker.cfa.ast.ITypedef convert(ITypedef t) {
        try {
            return new org.sosy_lab.cpachecker.cfa.ast.ITypedef(t.getName(), this.convert(this.getType(t)));
        }
        catch (DOMException e) {
            throw new CFAGenerationRuntimeException(e);
        }
    }

    private IType getType(ITypedef t) throws DOMException {
        return t.getType();
    }
}

