/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.Scope;

public class ASTConverterTest {
    private ASTConverter converter;

    @Before
    public final void setup() throws InvalidConfigurationException {
        this.converter = new ASTConverter(new Scope(), false, new LogManager(Configuration.defaultConfiguration()));
    }

    @Test
    public final void testCharacterExpression() {
        Assert.assertEquals((long)0L, (long)this.converter.parseCharacterLiteral("'\\000'", null));
        Assert.assertEquals((long)63L, (long)this.converter.parseCharacterLiteral("'\\077'", null));
        Assert.assertEquals((long)255L, (long)this.converter.parseCharacterLiteral("'\\xFF'", null));
        Assert.assertEquals((long)188L, (long)this.converter.parseCharacterLiteral("'\\xBC'", null));
        Assert.assertEquals((long)128L, (long)this.converter.parseCharacterLiteral("'\\x80'", null));
        Assert.assertEquals((long)127L, (long)this.converter.parseCharacterLiteral("'\\X7F'", null));
        Assert.assertEquals((long)92L, (long)this.converter.parseCharacterLiteral("'\\\\'", null));
        Assert.assertEquals((long)39L, (long)this.converter.parseCharacterLiteral("'\\''", null));
        Assert.assertEquals((long)34L, (long)this.converter.parseCharacterLiteral("'\\\"'", null));
        Assert.assertEquals((long)0L, (long)this.converter.parseCharacterLiteral("'\\0'", null));
        Assert.assertEquals((long)9L, (long)this.converter.parseCharacterLiteral("'\\t'", null));
        Assert.assertEquals((long)10L, (long)this.converter.parseCharacterLiteral("'\\n'", null));
        Assert.assertEquals((long)13L, (long)this.converter.parseCharacterLiteral("'\\r'", null));
        Assert.assertEquals((long)97L, (long)this.converter.parseCharacterLiteral("'a'", null));
        Assert.assertEquals((long)32L, (long)this.converter.parseCharacterLiteral("' '", null));
        Assert.assertEquals((long)57L, (long)this.converter.parseCharacterLiteral("'9'", null));
        Assert.assertEquals((long)180L, (long)this.converter.parseCharacterLiteral("'\u00b4'", null));
        Assert.assertEquals((long)180L, (long)this.converter.parseCharacterLiteral("'\u00b4'", null));
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression1() {
        this.converter.parseCharacterLiteral("", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression2() {
        this.converter.parseCharacterLiteral("'\\'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression3() {
        this.converter.parseCharacterLiteral("'aa'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression4() {
        this.converter.parseCharacterLiteral("'\\777'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression5() {
        this.converter.parseCharacterLiteral("'\\xFFF'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression6() {
        this.converter.parseCharacterLiteral("'\\z'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression7() {
        this.converter.parseCharacterLiteral("'\\0777'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression8() {
        this.converter.parseCharacterLiteral("'\\088'", null);
    }

    @Test(expected=CFAGenerationRuntimeException.class)
    public final void testInvalidCharacterExpression9() {
        this.converter.parseCharacterLiteral("'\\xGG'", null);
    }

    private String parseIntegerExpression(String s) {
        return this.converter.parseIntegerLiteral(s, null).toString();
    }

    @Test
    public final void testIntegerExpression() {
        Assert.assertEquals((Object)"0", (Object)this.parseIntegerExpression("0"));
        Assert.assertEquals((Object)"1", (Object)this.parseIntegerExpression("1"));
        Assert.assertEquals((Object)"2", (Object)this.parseIntegerExpression("2L"));
        Assert.assertEquals((Object)"3", (Object)this.parseIntegerExpression("3u"));
        Assert.assertEquals((Object)"4", (Object)this.parseIntegerExpression("4LL"));
        Assert.assertEquals((Object)"5", (Object)this.parseIntegerExpression("5uLl"));
        Assert.assertEquals((Object)"63", (Object)this.parseIntegerExpression("077"));
        Assert.assertEquals((Object)"2147483647", (Object)this.parseIntegerExpression("2147483647"));
        Assert.assertEquals((Object)"2147483647", (Object)this.parseIntegerExpression("0x7FFFFFFFL"));
        Assert.assertEquals((Object)"-2147483648", (Object)this.parseIntegerExpression("2147483648L"));
        Assert.assertEquals((Object)"-2147483648", (Object)this.parseIntegerExpression("0x80000000"));
        Assert.assertEquals((Object)"-1", (Object)this.parseIntegerExpression("4294967295"));
        Assert.assertEquals((Object)"-1", (Object)this.parseIntegerExpression("0xFFFFFFFFl"));
        Assert.assertEquals((Object)"0", (Object)this.parseIntegerExpression("4294967296l"));
        Assert.assertEquals((Object)"-294967296", (Object)this.parseIntegerExpression("4000000000"));
        Assert.assertEquals((Object)"4000000000", (Object)this.parseIntegerExpression("4000000000u"));
        Assert.assertEquals((Object)"2147483647", (Object)this.parseIntegerExpression("2147483647LL"));
        Assert.assertEquals((Object)"2147483647", (Object)this.parseIntegerExpression("0x7FFFFFFFlL"));
        Assert.assertEquals((Object)"2147483648", (Object)this.parseIntegerExpression("2147483648Ll"));
        Assert.assertEquals((Object)"2147483648", (Object)this.parseIntegerExpression("0x80000000LL"));
        Assert.assertEquals((Object)"4294967295", (Object)this.parseIntegerExpression("4294967295ll"));
        Assert.assertEquals((Object)"4294967295", (Object)this.parseIntegerExpression("0xFFFFFFFFLL"));
        Assert.assertEquals((Object)"4294967296", (Object)this.parseIntegerExpression("4294967296Ll"));
        Assert.assertEquals((Object)"4000000000", (Object)this.parseIntegerExpression("4000000000lL"));
        Assert.assertEquals((Object)"4000000000", (Object)this.parseIntegerExpression("4000000000uLL"));
        Assert.assertEquals((Object)"18446744073709551600", (Object)this.parseIntegerExpression("0xfffffffffffffff0ull"));
        Assert.assertEquals((Object)"-16", (Object)this.parseIntegerExpression("0xfffffffffffffff0ll"));
        Assert.assertEquals((Object)"9223372036854775807", (Object)this.parseIntegerExpression("9223372036854775807LL"));
        Assert.assertEquals((Object)"9223372036854775807", (Object)this.parseIntegerExpression("0x7FFFFFFFFFFFFFFFLL"));
        Assert.assertEquals((Object)"-9223372036854775808", (Object)this.parseIntegerExpression("9223372036854775808LL"));
        Assert.assertEquals((Object)"-9223372036854775808", (Object)this.parseIntegerExpression("0x8000000000000000LL"));
        Assert.assertEquals((Object)"9223372036854775808", (Object)this.parseIntegerExpression("9223372036854775808uLL"));
        Assert.assertEquals((Object)"9223372036854775808", (Object)this.parseIntegerExpression("0x8000000000000000uLL"));
        Assert.assertEquals((Object)"18446744073709551615", (Object)this.parseIntegerExpression("18446744073709551615uLL"));
        Assert.assertEquals((Object)"18446744073709551615", (Object)this.parseIntegerExpression("0xFFFFFFFFFFFFFFFFuLL"));
        Assert.assertEquals((Object)"-1", (Object)this.parseIntegerExpression("0xFFFFFFFFFFFFFFFF"));
        Assert.assertEquals((Object)"-1", (Object)this.parseIntegerExpression("0xFFFFFFFFFFFFFFFFLL"));
        Assert.assertEquals((Object)"1", (Object)this.parseIntegerExpression("18446744073709551617uLL"));
    }
}

