/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse;

import java.io.IOException;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.parser.c.ANSICParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.GCCParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.ICParserExtensionConfiguration;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.CFABuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.Scope;
import org.sosy_lab.cpachecker.exceptions.ParserException;

public abstract class AbstractEclipseCParser<T>
implements CParser {
    private boolean ignoreCasts;
    protected final ILanguage language;
    protected final IParserLogService parserLog = ParserFactory.createDefaultLogService();
    private final LogManager logger;
    private final Timer parseTimer = new Timer();
    private final Timer cfaTimer = new Timer();
    protected static final int PARSER_OPTIONS = 12;

    protected AbstractEclipseCParser(LogManager pLogger, CParser.Dialect dialect) {
        this.logger = pLogger;
        switch (dialect) {
            case C99: {
                this.language = new CLanguage((ICParserExtensionConfiguration)new ANSICParserExtensionConfiguration());
                break;
            }
            case GNUC: {
                this.language = new CLanguage((ICParserExtensionConfiguration)new GCCParserExtensionConfiguration());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown C dialect");
            }
        }
    }

    protected abstract T wrapCode(String var1);

    protected abstract T wrapFile(String var1) throws IOException;

    @Override
    public ParseResult parseFile(String pFilename) throws ParserException, IOException {
        return this.buildCFA(this.parse(this.wrapFile(pFilename)));
    }

    @Override
    public ParseResult parseString(String pCode) throws ParserException {
        return this.buildCFA(this.parse(this.wrapCode(pCode)));
    }

    @Override
    public IASTNode parseSingleStatement(String pCode) throws ParserException {
        IASTTranslationUnit ast = this.parse(this.wrapCode(pCode));
        IASTDeclaration[] declarations = ast.getDeclarations();
        if (declarations == null || declarations.length != 1 || !(declarations[0] instanceof IASTFunctionDefinition)) {
            throw new ParserException("Not a single function: " + ast.getRawSignature());
        }
        IASTFunctionDefinition func = (IASTFunctionDefinition)declarations[0];
        IASTStatement body = func.getBody();
        if (!(body instanceof IASTCompoundStatement)) {
            throw new ParserException("Function has an unexpected " + body.getClass().getSimpleName() + " as body: " + func.getRawSignature());
        }
        IASTStatement[] statements = ((IASTCompoundStatement)body).getStatements();
        if ((statements.length != 2 || statements[1] != null) && statements.length != 1) {
            throw new ParserException("Not exactly one statement in function body: " + body);
        }
        return new ASTConverter(new Scope(), this.ignoreCasts, this.logger).convert(statements[0]);
    }

    private IASTTranslationUnit parse(T codeReader) throws ParserException {
        this.parseTimer.start();
        try {
            IASTTranslationUnit iASTTranslationUnit = this.getASTTranslationUnit(codeReader);
            return iASTTranslationUnit;
        }
        catch (CFAGenerationRuntimeException e) {
            throw new ParserException(e);
        }
        catch (CoreException e) {
            throw new ParserException(e);
        }
        finally {
            this.parseTimer.stop();
        }
    }

    protected abstract IASTTranslationUnit getASTTranslationUnit(T var1) throws ParserException, CFAGenerationRuntimeException, CoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult buildCFA(IASTTranslationUnit ast) throws ParserException {
        this.cfaTimer.start();
        try {
            CFABuilder builder = new CFABuilder(this.logger, this.ignoreCasts);
            try {
                ast.accept((ASTVisitor)builder);
            }
            catch (CFAGenerationRuntimeException e) {
                throw new ParserException(e);
            }
            ParseResult parseResult = new ParseResult(builder.getCFAs(), builder.getCFANodes(), builder.getGlobalDeclarations());
            return parseResult;
        }
        finally {
            this.cfaTimer.stop();
        }
    }

    @Override
    public Timer getParseTime() {
        return this.parseTimer;
    }

    @Override
    public Timer getCFAConstructionTime() {
        return this.cfaTimer;
    }

    public void setIgnoreCasts(boolean pIgnoreCasts) {
        this.ignoreCasts = pIgnoreCasts;
    }

    protected static class StubScannerInfo
    implements IScannerInfo {
        protected static final IScannerInfo instance = new StubScannerInfo();

        protected StubScannerInfo() {
        }

        public Map<String, String> getDefinedSymbols() {
            return null;
        }

        public String[] getIncludePaths() {
            return new String[0];
        }
    }

    private static class CLanguage
    extends GCCLanguage {
        private final ICParserExtensionConfiguration parserConfig;

        public CLanguage(ICParserExtensionConfiguration parserConfig) {
            this.parserConfig = parserConfig;
        }

        protected ICParserExtensionConfiguration getParserExtensionConfiguration() {
            return this.parserConfig;
        }
    }
}

