/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse;

import com.google.common.collect.Lists;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.CFAFunctionBuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.Scope;

class CFABuilder
extends ASTVisitor {
    private Queue<IASTFunctionDefinition> functionDeclarations = new LinkedList<IASTFunctionDefinition>();
    private final Map<String, CFAFunctionDefinitionNode> cfas = new HashMap<String, CFAFunctionDefinitionNode>();
    private final SortedSetMultimap<String, CFANode> cfaNodes = TreeMultimap.create();
    private final List<Pair<IASTDeclaration, String>> globalDeclarations = Lists.newArrayList();
    private final Scope scope = new Scope();
    private final ASTConverter astCreator;
    private final LogManager logger;
    private final boolean ignoreCasts;

    public CFABuilder(LogManager pLogger, boolean pIgnoreCasts) {
        this.logger = pLogger;
        this.ignoreCasts = pIgnoreCasts;
        this.astCreator = new ASTConverter(this.scope, pIgnoreCasts, this.logger);
        if (pIgnoreCasts) {
            this.logger.log(Level.WARNING, new Object[]{"Ignoring all casts in the program because of user request!"});
        }
        this.shouldVisitDeclarations = true;
        this.shouldVisitEnumerators = true;
        this.shouldVisitProblems = true;
        this.shouldVisitTranslationUnit = true;
    }

    public Map<String, CFAFunctionDefinitionNode> getCFAs() {
        return this.cfas;
    }

    public SortedSetMultimap<String, CFANode> getCFANodes() {
        return this.cfaNodes;
    }

    public List<Pair<IASTDeclaration, String>> getGlobalDeclarations() {
        return this.globalDeclarations;
    }

    public int visit(org.eclipse.cdt.core.dom.ast.IASTDeclaration declaration) {
        IASTFileLocation fileloc = declaration.getFileLocation();
        if (declaration instanceof IASTSimpleDeclaration) {
            return this.handleSimpleDeclaration((IASTSimpleDeclaration)declaration, fileloc);
        }
        if (declaration instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fd = (IASTFunctionDefinition)declaration;
            this.functionDeclarations.add(fd);
            IASTFunctionDeclaration functionDefinition = this.astCreator.convert(fd);
            if (this.astCreator.existsSideAssignment()) {
                throw new CFAGenerationRuntimeException("Function definition has side effect", (IASTNode)fd);
            }
            this.globalDeclarations.add((Pair<IASTDeclaration, String>)Pair.of((Object)functionDefinition, (Object)fd.getRawSignature()));
            return 1;
        }
        if (declaration instanceof IASTProblemDeclaration) {
            this.visit(((IASTProblemDeclaration)declaration).getProblem());
            return 1;
        }
        if (declaration instanceof IASTASMDeclaration) {
            this.logger.log(Level.WARNING, new Object[]{"Ignoring inline assembler code at line " + fileloc.getStartingLineNumber() + ", analysis is probably unsound!"});
            return 1;
        }
        throw new CFAGenerationRuntimeException("Unknown declaration type " + declaration.getClass().getSimpleName(), (IASTNode)declaration);
    }

    private int handleSimpleDeclaration(IASTSimpleDeclaration sd, IASTFileLocation fileloc) {
        List<IASTDeclaration> newDs = this.astCreator.convert(sd);
        assert (!newDs.isEmpty());
        if (this.astCreator.existsSideAssignment()) {
            throw new CFAGenerationRuntimeException("Initializer of global variable has side effect", (IASTNode)sd);
        }
        String rawSignature = sd.getRawSignature();
        for (IASTDeclaration newD : newDs) {
            if (newD instanceof IASTVariableDeclaration) {
                this.scope.registerDeclaration(newD);
            } else if (newD instanceof IASTFunctionDeclaration) {
                this.scope.registerFunctionDeclaration((IASTFunctionDeclaration)newD);
            }
            this.globalDeclarations.add((Pair<IASTDeclaration, String>)Pair.of((Object)newD, (Object)rawSignature));
        }
        return 1;
    }

    public int visit(IASTProblem problem) {
        throw new CFAGenerationRuntimeException(problem.getMessage(), (IASTNode)problem);
    }

    public int leave(IASTTranslationUnit translationUnit) {
        for (IASTFunctionDefinition declaration : this.functionDeclarations) {
            CFAFunctionBuilder functionBuilder = new CFAFunctionBuilder(this.logger, this.ignoreCasts, this.scope, this.astCreator);
            declaration.accept((ASTVisitor)functionBuilder);
            CFAFunctionDefinitionNode startNode = functionBuilder.getStartNode();
            String functionName = startNode.getFunctionName();
            if (this.cfas.containsKey(functionName)) {
                throw new CFAGenerationRuntimeException("Duplicate function " + functionName);
            }
            this.cfas.put(functionName, startNode);
            this.cfaNodes.putAll((Object)functionName, functionBuilder.getCfaNodes());
        }
        return 3;
    }
}

