/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.ast.IASTAssignment;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.IASTStatement;
import org.sosy_lab.cpachecker.cfa.ast.IASTVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.objectmodel.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.BlankEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAFunctionExitNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.DeclarationEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionDefinitionNode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.ReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.StatementEdge;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.ASTConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.Scope;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;

class CFAFunctionBuilder
extends ASTVisitor {
    private final Deque<CFANode> locStack = new ArrayDeque<CFANode>();
    private final Deque<CFANode> loopStartStack = new ArrayDeque<CFANode>();
    private final Deque<CFANode> loopNextStack = new ArrayDeque<CFANode>();
    private final Deque<CFANode> elseStack = new ArrayDeque<CFANode>();
    private final Deque<IASTExpression> switchExprStack = new ArrayDeque<IASTExpression>();
    private final Deque<CFANode> switchCaseStack = new ArrayDeque<CFANode>();
    private final Map<String, CFALabelNode> labelMap = new HashMap<String, CFALabelNode>();
    private final Multimap<String, CFANode> gotoLabelNeeded = ArrayListMultimap.create();
    private CFAFunctionDefinitionNode cfa = null;
    private final Set<CFANode> cfaNodes = new HashSet<CFANode>();
    private final Scope scope;
    private final ASTConverter astCreator;
    private final LogManager logger;
    private boolean printedAsmWarning = false;

    public CFAFunctionBuilder(LogManager pLogger, boolean pIgnoreCasts, Scope pScope, ASTConverter pAstCreator) {
        this.logger = pLogger;
        this.scope = pScope;
        this.astCreator = pAstCreator;
        this.shouldVisitDeclarations = true;
        this.shouldVisitEnumerators = true;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitProblems = true;
        this.shouldVisitStatements = true;
    }

    CFAFunctionDefinitionNode getStartNode() {
        Preconditions.checkState((this.cfa != null ? 1 : 0) != 0);
        return this.cfa;
    }

    Set<CFANode> getCfaNodes() {
        Preconditions.checkState((this.cfa != null ? 1 : 0) != 0);
        return this.cfaNodes;
    }

    public int visit(org.eclipse.cdt.core.dom.ast.IASTDeclaration declaration) {
        IASTFileLocation fileloc = declaration.getFileLocation();
        if (declaration instanceof IASTSimpleDeclaration) {
            return this.handleSimpleDeclaration((IASTSimpleDeclaration)declaration, fileloc);
        }
        if (declaration instanceof IASTFunctionDefinition) {
            return this.handleFunctionDefinition((IASTFunctionDefinition)declaration, fileloc);
        }
        if (declaration instanceof IASTProblemDeclaration) {
            this.visit(((IASTProblemDeclaration)declaration).getProblem());
            return 1;
        }
        if (declaration instanceof IASTASMDeclaration) {
            return this.ignoreASMDeclaration(fileloc, (IASTNode)declaration);
        }
        throw new CFAGenerationRuntimeException("Unknown declaration type " + declaration.getClass().getSimpleName(), (IASTNode)declaration);
    }

    private int handleSimpleDeclaration(IASTSimpleDeclaration sd, IASTFileLocation fileloc) {
        assert (this.locStack.size() > 0) : "not in a function's scope";
        CFANode prevNode = this.locStack.pop();
        CFANode nextNode = this.addDeclarationsToCFA(sd, fileloc.getStartingLineNumber(), prevNode);
        assert (nextNode != null);
        this.locStack.push(nextNode);
        return 1;
    }

    private int handleFunctionDefinition(IASTFunctionDefinition declaration, IASTFileLocation fileloc) {
        if (this.locStack.size() != 0) {
            throw new CFAGenerationRuntimeException("Nested function declarations?");
        }
        assert (this.labelMap.isEmpty());
        assert (this.gotoLabelNeeded.isEmpty());
        assert (this.cfa == null);
        IASTFunctionDeclaration fdef = this.astCreator.convert(declaration);
        String nameOfFunction = fdef.getName();
        assert (!nameOfFunction.isEmpty());
        this.scope.enterFunction(fdef);
        List<IASTParameterDeclaration> parameters = fdef.getDeclSpecifier().getParameters();
        ArrayList<String> parameterNames = new ArrayList<String>(parameters.size());
        for (IASTParameterDeclaration param : parameters) {
            this.scope.registerDeclaration(param);
            parameterNames.add(param.getName());
        }
        CFAFunctionExitNode returnNode = new CFAFunctionExitNode(fileloc.getEndingLineNumber(), nameOfFunction);
        this.cfaNodes.add(returnNode);
        FunctionDefinitionNode startNode = new FunctionDefinitionNode(fileloc.getStartingLineNumber(), fdef, returnNode, parameterNames);
        this.cfaNodes.add(startNode);
        this.cfa = startNode;
        CFANode nextNode = new CFANode(fileloc.getStartingLineNumber(), nameOfFunction);
        this.cfaNodes.add(nextNode);
        this.locStack.add(nextNode);
        BlankEdge dummyEdge = new BlankEdge("", fileloc.getStartingLineNumber(), startNode, nextNode, "Function start dummy edge");
        this.addToCFA(dummyEdge);
        return 3;
    }

    private int ignoreASMDeclaration(IASTFileLocation fileloc, IASTNode asmCode) {
        this.logger.log(Level.FINER, new Object[]{"Ignoring inline assembler code at line", fileloc.getStartingLineNumber()});
        if (!this.printedAsmWarning) {
            this.logger.log(Level.WARNING, new Object[]{"Inline assembler ignored in function " + this.cfa.getFunctionName() + ", analysis is probably unsound!"});
            this.printedAsmWarning = true;
        }
        CFANode prevNode = this.locStack.pop();
        CFANode nextNode = new CFANode(fileloc.getStartingLineNumber(), this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        this.locStack.push(nextNode);
        BlankEdge edge = new BlankEdge(asmCode.getRawSignature(), fileloc.getStartingLineNumber(), prevNode, nextNode, "Ignored inline assembler code");
        this.addToCFA(edge);
        return 1;
    }

    public int leave(org.eclipse.cdt.core.dom.ast.IASTDeclaration declaration) {
        if (declaration instanceof IASTFunctionDefinition) {
            if (this.locStack.size() != 1) {
                throw new CFAGenerationRuntimeException("Depth wrong. Geoff needs to do more work");
            }
            CFANode lastNode = this.locStack.pop();
            if (CFACreationUtils.isReachableNode(lastNode)) {
                BlankEdge blankEdge = new BlankEdge("", lastNode.getLineNumber(), lastNode, this.cfa.getExitNode(), "default return");
                this.addToCFA(blankEdge);
            }
            if (!this.gotoLabelNeeded.isEmpty()) {
                throw new CFAGenerationRuntimeException("Following labels were not found in function " + this.cfa.getFunctionName() + ": " + this.gotoLabelNeeded.keySet());
            }
            CFATraversal.NodeCollectingCFAVisitor visitor = new CFATraversal.NodeCollectingCFAVisitor();
            CFATraversal.dfs().traverse(this.cfa, visitor);
            Set<CFANode> reachableNodes = visitor.getVisitedNodes();
            for (CFALabelNode cFALabelNode : this.labelMap.values()) {
                if (reachableNodes.contains(cFALabelNode)) continue;
                this.logDeadLabel(cFALabelNode);
                while (cFALabelNode.getNumEnteringEdges() > 0) {
                    CFACreationUtils.removeEdgeFromNodes(cFALabelNode.getEnteringEdge(0));
                }
                CFACreationUtils.removeChainOfNodesFromCFA(cFALabelNode);
            }
            Iterator<CFANode> it = this.cfaNodes.iterator();
            while (it.hasNext()) {
                CFANode cFANode = it.next();
                if (reachableNodes.contains(cFANode)) continue;
                it.remove();
            }
            this.scope.leaveFunction();
        }
        return 3;
    }

    private void logDeadLabel(CFALabelNode n) {
        Level level = Level.INFO;
        if (n.getLabel().matches("(switch|while)_(\\d+_[a-z0-9]+|[a-z0-9]+___\\d+)")) {
            level = Level.FINER;
        }
        this.logger.log(level, new Object[]{"Dead code detected at line", n.getLineNumber() + ": Label", n.getLabel(), "is not reachable."});
    }

    public int visit(org.eclipse.cdt.core.dom.ast.IASTStatement statement) {
        IASTFileLocation fileloc = statement.getFileLocation();
        if (statement.getPropertyInParent() == IASTIfStatement.ELSE) {
            CFANode prevNode = this.locStack.pop();
            CFANode nextNode = this.locStack.peek();
            if (CFACreationUtils.isReachableNode(prevNode)) {
                BlankEdge blankEdge = new BlankEdge("", nextNode.getLineNumber(), prevNode, nextNode, "");
                this.addToCFA(blankEdge);
            }
            CFANode elseNode = this.elseStack.pop();
            this.locStack.push(elseNode);
        }
        if (statement instanceof IASTCompoundStatement) {
            this.scope.enterBlock();
        } else if (statement instanceof IASTExpressionStatement) {
            this.handleExpressionStatement((IASTExpressionStatement)statement, fileloc);
        } else if (statement instanceof IASTIfStatement) {
            this.handleIfStatement((IASTIfStatement)statement, fileloc);
        } else if (statement instanceof IASTWhileStatement) {
            this.handleWhileStatement((IASTWhileStatement)statement, fileloc);
        } else {
            if (statement instanceof IASTForStatement) {
                return this.visitForStatement((IASTForStatement)statement, fileloc);
            }
            if (statement instanceof IASTBreakStatement) {
                this.handleBreakStatement((IASTBreakStatement)statement, fileloc);
            } else if (statement instanceof IASTContinueStatement) {
                this.handleContinueStatement((IASTContinueStatement)statement, fileloc);
            } else if (statement instanceof IASTLabelStatement) {
                this.handleLabelStatement((IASTLabelStatement)statement, fileloc);
            } else if (statement instanceof IASTGotoStatement) {
                this.handleGotoStatement((IASTGotoStatement)statement, fileloc);
            } else if (statement instanceof IASTReturnStatement) {
                this.handleReturnStatement((IASTReturnStatement)statement, fileloc);
            } else {
                if (statement instanceof IASTSwitchStatement) {
                    return this.handleSwitchStatement((IASTSwitchStatement)statement, fileloc);
                }
                if (statement instanceof IASTCaseStatement) {
                    this.handleCaseStatement((IASTCaseStatement)statement, fileloc);
                } else if (statement instanceof IASTDefaultStatement) {
                    this.handleDefaultStatement((IASTDefaultStatement)statement, fileloc);
                } else if (!(statement instanceof IASTNullStatement) && !(statement instanceof IASTDeclarationStatement)) {
                    if (statement instanceof IASTProblemStatement) {
                        this.visit(((IASTProblemStatement)statement).getProblem());
                    } else {
                        throw new CFAGenerationRuntimeException("Unknown AST node " + statement.getClass().getSimpleName(), (IASTNode)statement);
                    }
                }
            }
        }
        return 3;
    }

    private void handleExpressionStatement(IASTExpressionStatement exprStatement, IASTFileLocation fileloc) {
        if (exprStatement.getParent() instanceof IASTForStatement && exprStatement == ((IASTForStatement)exprStatement.getParent()).getInitializerStatement()) {
            return;
        }
        CFANode prevNode = this.locStack.pop();
        CFANode nextNode = new CFANode(fileloc.getStartingLineNumber(), this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        IASTStatement statement = this.astCreator.convert(exprStatement);
        String rawSignature = exprStatement.getRawSignature();
        while (this.astCreator.existsSideAssignment()) {
            StatementEdge previous;
            org.sosy_lab.cpachecker.cfa.ast.IASTNode middle = this.astCreator.getSideAssignment();
            if (middle instanceof IASTFunctionCallAssignmentStatement) {
                previous = new StatementEdge(rawSignature, (IASTFunctionCallAssignmentStatement)middle, fileloc.getStartingLineNumber(), prevNode, nextNode);
                this.addToCFA(previous);
            } else if (middle instanceof IASTAssignment) {
                previous = new StatementEdge(rawSignature, (IASTStatement)middle, fileloc.getStartingLineNumber(), prevNode, nextNode);
                this.addToCFA(previous);
            } else {
                DeclarationEdge previousdec = new DeclarationEdge(rawSignature, fileloc.getStartingLineNumber(), prevNode, nextNode, (IASTDeclaration)middle);
                this.addToCFA(previousdec);
            }
            prevNode = nextNode;
            nextNode = new CFANode(fileloc.getStartingLineNumber(), this.cfa.getFunctionName());
            this.cfaNodes.add(nextNode);
        }
        this.locStack.push(nextNode);
        StatementEdge edge = new StatementEdge(rawSignature, statement, fileloc.getStartingLineNumber(), prevNode, nextNode);
        this.addToCFA(edge);
    }

    private CONDITION getConditionKind(org.eclipse.cdt.core.dom.ast.IASTExpression cond) {
        if (cond instanceof IASTLiteralExpression && ((IASTLiteralExpression)cond).getKind() == 0) {
            int c = Integer.parseInt(cond.getRawSignature());
            if (c == 0) {
                return CONDITION.ALWAYS_FALSE;
            }
            return CONDITION.ALWAYS_TRUE;
        }
        return CONDITION.NORMAL;
    }

    private void handleIfStatement(IASTIfStatement ifStatement, IASTFileLocation fileloc) {
        CFANode elseNode;
        CFANode prevNode = this.locStack.pop();
        CFANode postIfNode = new CFANode(fileloc.getEndingLineNumber(), this.cfa.getFunctionName());
        this.cfaNodes.add(postIfNode);
        this.locStack.push(postIfNode);
        CFANode thenNode = new CFANode(fileloc.getStartingLineNumber(), this.cfa.getFunctionName());
        this.cfaNodes.add(thenNode);
        this.locStack.push(thenNode);
        if (ifStatement.getElseClause() == null) {
            elseNode = postIfNode;
        } else {
            elseNode = new CFANode(fileloc.getStartingLineNumber(), this.cfa.getFunctionName());
            this.cfaNodes.add(elseNode);
            this.elseStack.push(elseNode);
        }
        this.createConditionEdges(ifStatement.getConditionExpression(), fileloc.getStartingLineNumber(), prevNode, thenNode, elseNode);
    }

    private void handleWhileStatement(IASTWhileStatement whileStatement, IASTFileLocation fileloc) {
        CFANode prevNode = this.locStack.pop();
        CFANode loopStart = new CFANode(fileloc.getStartingLineNumber(), this.cfa.getFunctionName());
        this.cfaNodes.add(loopStart);
        loopStart.setLoopStart();
        this.loopStartStack.push(loopStart);
        CFANode firstLoopNode = new CFANode(fileloc.getStartingLineNumber(), this.cfa.getFunctionName());
        this.cfaNodes.add(firstLoopNode);
        CFALabelNode postLoopNode = new CFALabelNode(fileloc.getEndingLineNumber(), this.cfa.getFunctionName(), "");
        this.cfaNodes.add(postLoopNode);
        this.loopNextStack.push(postLoopNode);
        this.locStack.push(postLoopNode);
        this.locStack.push(firstLoopNode);
        BlankEdge blankEdge = new BlankEdge("", fileloc.getStartingLineNumber(), prevNode, loopStart, "while");
        this.addToCFA(blankEdge);
        this.createConditionEdges(whileStatement.getCondition(), fileloc.getStartingLineNumber(), loopStart, firstLoopNode, postLoopNode);
    }

    private void createConditionEdges(org.eclipse.cdt.core.dom.ast.IASTExpression condition, int filelocStart, CFANode rootNode, CFANode thenNode, CFANode elseNode) {
        assert (condition != null);
        CONDITION kind = this.getConditionKind(condition);
        String rawSignature = condition.getRawSignature();
        switch (kind) {
            case ALWAYS_FALSE: {
                BlankEdge falseEdge = new BlankEdge(rawSignature, filelocStart, rootNode, elseNode, "");
                this.addToCFA(falseEdge);
                break;
            }
            case ALWAYS_TRUE: {
                BlankEdge trueEdge = new BlankEdge(rawSignature, filelocStart, rootNode, thenNode, "");
                this.addToCFA(trueEdge);
                break;
            }
            case NORMAL: {
                this.buildConditionTree(condition, filelocStart, rootNode, thenNode, elseNode, thenNode, elseNode, true, true);
                break;
            }
            default: {
                throw new InternalError("Missing switch clause");
            }
        }
    }

    private void buildConditionTree(org.eclipse.cdt.core.dom.ast.IASTExpression condition, int filelocStart, CFANode rootNode, CFANode thenNode, CFANode elseNode, CFANode thenNodeForLastThen, CFANode elseNodeForLastElse, boolean furtherThenComputation, boolean furtherElseComputation) {
        while (condition instanceof IASTUnaryExpression && ((IASTUnaryExpression)condition).getOperator() == 11) {
            condition = ((IASTUnaryExpression)condition).getOperand();
        }
        if (condition instanceof org.eclipse.cdt.core.dom.ast.IASTBinaryExpression && ((org.eclipse.cdt.core.dom.ast.IASTBinaryExpression)condition).getOperator() == 15) {
            CFANode innerNode = new CFANode(filelocStart, this.cfa.getFunctionName());
            this.cfaNodes.add(innerNode);
            this.buildConditionTree(((org.eclipse.cdt.core.dom.ast.IASTBinaryExpression)condition).getOperand1(), filelocStart, rootNode, innerNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, true, false);
            this.buildConditionTree(((org.eclipse.cdt.core.dom.ast.IASTBinaryExpression)condition).getOperand2(), filelocStart, innerNode, thenNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
        } else if (condition instanceof org.eclipse.cdt.core.dom.ast.IASTBinaryExpression && ((org.eclipse.cdt.core.dom.ast.IASTBinaryExpression)condition).getOperator() == 16) {
            CFANode innerNode = new CFANode(filelocStart, this.cfa.getFunctionName());
            this.cfaNodes.add(innerNode);
            this.buildConditionTree(((org.eclipse.cdt.core.dom.ast.IASTBinaryExpression)condition).getOperand1(), filelocStart, rootNode, thenNode, innerNode, thenNodeForLastThen, elseNodeForLastElse, false, true);
            this.buildConditionTree(((org.eclipse.cdt.core.dom.ast.IASTBinaryExpression)condition).getOperand2(), filelocStart, innerNode, thenNode, elseNode, thenNodeForLastThen, elseNodeForLastElse, true, true);
        } else {
            Pair<IASTExpression, CFANode> pair = this.handleSideAssignmentsInConditions(condition, rootNode);
            if (furtherThenComputation) {
                thenNodeForLastThen = thenNode;
            }
            if (furtherElseComputation) {
                elseNodeForLastElse = elseNode;
            }
            AssumeEdge assumeEdgeFalse = new AssumeEdge("!(" + condition.getRawSignature() + ")", filelocStart, (CFANode)pair.getSecond(), elseNodeForLastElse, (IASTExpression)pair.getFirst(), false);
            this.addToCFA(assumeEdgeFalse);
            AssumeEdge assumeEdgeTrue = new AssumeEdge(condition.getRawSignature(), filelocStart, (CFANode)pair.getSecond(), thenNodeForLastThen, (IASTExpression)pair.getFirst(), true);
            this.addToCFA(assumeEdgeTrue);
        }
    }

    private Pair<IASTExpression, CFANode> handleSideAssignmentsInConditions(org.eclipse.cdt.core.dom.ast.IASTExpression condition, CFANode rootNode) {
        IASTExpression exp = this.astCreator.convertBooleanExpression(condition);
        String rawSignature = condition.getRawSignature();
        CFANode between = null;
        while (this.astCreator.existsSideAssignment()) {
            StatementEdge previous;
            org.sosy_lab.cpachecker.cfa.ast.IASTNode middle = this.astCreator.getSideAssignment();
            between = new CFANode(middle.getFileLocation().getStartingLineNumber(), this.cfa.getFunctionName());
            if (middle instanceof IASTFunctionCallAssignmentStatement) {
                previous = new StatementEdge(rawSignature, (IASTFunctionCallAssignmentStatement)middle, middle.getFileLocation().getStartingLineNumber(), rootNode, between);
                this.addToCFA(previous);
            } else if (middle instanceof IASTAssignment) {
                previous = new StatementEdge(rawSignature, (IASTStatement)middle, middle.getFileLocation().getStartingLineNumber(), rootNode, between);
                this.addToCFA(previous);
            } else {
                DeclarationEdge previousdec = new DeclarationEdge(rawSignature, middle.getFileLocation().getStartingLineNumber(), rootNode, between, (IASTDeclaration)middle);
                this.addToCFA(previousdec);
            }
            rootNode = between;
            this.cfaNodes.add(between);
        }
        return Pair.of((Object)exp, (Object)rootNode);
    }

    private int visitForStatement(IASTForStatement forStatement, IASTFileLocation fileloc) {
        int filelocStart = fileloc.getStartingLineNumber();
        CFANode prevNode = this.locStack.pop();
        CFANode loopInit = new CFANode(filelocStart, this.cfa.getFunctionName());
        this.cfaNodes.add(loopInit);
        this.addToCFA(new BlankEdge("", filelocStart, prevNode, loopInit, "for"));
        CFANode loopStart = this.createInitEdgeForForLoop(forStatement.getInitializerStatement(), filelocStart, loopInit);
        loopStart.setLoopStart();
        CFALabelNode loopEnd = new CFALabelNode(filelocStart, this.cfa.getFunctionName(), "");
        this.cfaNodes.add(loopEnd);
        this.loopStartStack.push(loopEnd);
        this.createLastEdgeForForLoop(forStatement.getIterationExpression(), filelocStart, loopEnd, loopStart);
        CFANode firstLoopNode = new CFANode(filelocStart, this.cfa.getFunctionName());
        this.cfaNodes.add(firstLoopNode);
        CFALabelNode postLoopNode = new CFALabelNode(fileloc.getEndingLineNumber(), this.cfa.getFunctionName(), "");
        this.cfaNodes.add(postLoopNode);
        this.loopNextStack.push(postLoopNode);
        this.locStack.push(postLoopNode);
        this.locStack.push(firstLoopNode);
        this.createConditionEdgesForForLoop(forStatement.getConditionExpression(), filelocStart, loopStart, postLoopNode, firstLoopNode);
        forStatement.getBody().accept((ASTVisitor)this);
        CFANode lastNodeInLoop = this.locStack.pop();
        assert (loopEnd == this.loopStartStack.pop());
        assert (postLoopNode == this.loopNextStack.pop());
        assert (postLoopNode == this.locStack.peek());
        if (CFACreationUtils.isReachableNode(lastNodeInLoop)) {
            BlankEdge blankEdge = new BlankEdge("", lastNodeInLoop.getLineNumber(), lastNodeInLoop, loopEnd, "");
            this.addToCFA(blankEdge);
        }
        return 1;
    }

    private CFANode createInitEdgeForForLoop(org.eclipse.cdt.core.dom.ast.IASTStatement statement, int filelocStart, CFANode loopInit) {
        if (statement instanceof IASTDeclarationStatement) {
            org.eclipse.cdt.core.dom.ast.IASTDeclaration decl = ((IASTDeclarationStatement)statement).getDeclaration();
            if (!(decl instanceof IASTSimpleDeclaration)) {
                throw new CFAGenerationRuntimeException("unknown init-statement in for-statement", (IASTNode)decl);
            }
            return this.addDeclarationsToCFA((IASTSimpleDeclaration)decl, filelocStart, loopInit);
        }
        if (statement instanceof IASTExpressionStatement) {
            CFANode nextNode = new CFANode(filelocStart, this.cfa.getFunctionName());
            this.cfaNodes.add(nextNode);
            StatementEdge initEdge = new StatementEdge(statement.getRawSignature(), this.astCreator.convert((IASTExpressionStatement)statement), filelocStart, loopInit, nextNode);
            this.addToCFA(initEdge);
            return nextNode;
        }
        if (statement instanceof IASTNullStatement) {
            return loopInit;
        }
        throw new CFAGenerationRuntimeException("unknown init-statement in for-statement", (IASTNode)statement);
    }

    private CFANode addDeclarationsToCFA(IASTSimpleDeclaration sd, int filelocStart, CFANode prevNode) {
        List<IASTDeclaration> declList = this.astCreator.convert(sd);
        String rawSignature = sd.getRawSignature();
        while (this.astCreator.existsSideAssignment()) {
            AbstractCFAEdge edge;
            CFANode nextNode = new CFANode(filelocStart, this.cfa.getFunctionName());
            this.cfaNodes.add(nextNode);
            org.sosy_lab.cpachecker.cfa.ast.IASTNode sideeffect = this.astCreator.getSideAssignment();
            if (sideeffect instanceof IASTStatement) {
                edge = new StatementEdge(rawSignature, (IASTStatement)sideeffect, filelocStart, prevNode, nextNode);
            } else if (sideeffect instanceof IASTDeclaration) {
                edge = new DeclarationEdge(rawSignature, filelocStart, prevNode, nextNode, (IASTDeclaration)sideeffect);
            } else {
                throw new AssertionError((Object)("Unknown case of side-effect statement: " + sideeffect));
            }
            this.addToCFA(edge);
            prevNode = nextNode;
        }
        for (IASTDeclaration newD : declList) {
            if (newD instanceof IASTVariableDeclaration) {
                this.scope.registerDeclaration(newD);
            } else if (newD instanceof IASTFunctionDeclaration) {
                this.scope.registerFunctionDeclaration((IASTFunctionDeclaration)newD);
            }
            CFANode nextNode = new CFANode(filelocStart, this.cfa.getFunctionName());
            this.cfaNodes.add(nextNode);
            DeclarationEdge edge = new DeclarationEdge(rawSignature, filelocStart, prevNode, nextNode, newD);
            this.addToCFA(edge);
            prevNode = nextNode;
        }
        return prevNode;
    }

    private void createLastEdgeForForLoop(org.eclipse.cdt.core.dom.ast.IASTExpression exp, int filelocStart, CFANode loopEnd, CFANode loopStart) {
        org.sosy_lab.cpachecker.cfa.ast.IASTNode node = this.astCreator.convertExpressionWithSideEffects(exp);
        if (exp == null) {
            BlankEdge blankEdge = new BlankEdge("", filelocStart, loopEnd, loopStart, "");
            this.addToCFA(blankEdge);
        } else if (node instanceof IASTIdExpression) {
            BlankEdge blankEdge = new BlankEdge(node.toASTString(), filelocStart, loopEnd, loopStart, "");
            this.addToCFA(blankEdge);
        } else if (node instanceof IASTExpressionAssignmentStatement) {
            StatementEdge lastEdge = new StatementEdge(exp.getRawSignature(), (IASTExpressionAssignmentStatement)node, filelocStart, loopEnd, loopStart);
            this.addToCFA(lastEdge);
        } else if (node instanceof IASTFunctionCallAssignmentStatement) {
            StatementEdge edge = new StatementEdge(exp.getRawSignature(), (IASTFunctionCallAssignmentStatement)node, filelocStart, loopEnd, loopStart);
            this.addToCFA(edge);
        } else {
            throw new AssertionError((Object)("CFABuilder: unknown iteration-expressions in for-statement:\n" + exp.getClass()));
        }
    }

    private void createConditionEdgesForForLoop(org.eclipse.cdt.core.dom.ast.IASTExpression condition, int filelocStart, CFANode loopStart, CFANode postLoopNode, CFANode firstLoopNode) {
        if (condition == null) {
            BlankEdge blankEdge = new BlankEdge("", filelocStart, loopStart, firstLoopNode, "");
            this.addToCFA(blankEdge);
        } else {
            this.createConditionEdges(condition, filelocStart, loopStart, firstLoopNode, postLoopNode);
        }
    }

    private void handleBreakStatement(IASTBreakStatement breakStatement, IASTFileLocation fileloc) {
        CFANode prevNode = this.locStack.pop();
        CFANode postLoopNode = this.loopNextStack.peek();
        BlankEdge blankEdge = new BlankEdge(breakStatement.getRawSignature(), fileloc.getStartingLineNumber(), prevNode, postLoopNode, "break");
        this.addToCFA(blankEdge);
        CFANode nextNode = new CFANode(fileloc.getEndingLineNumber(), this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        this.locStack.push(nextNode);
    }

    private void handleContinueStatement(IASTContinueStatement continueStatement, IASTFileLocation fileloc) {
        CFANode prevNode = this.locStack.pop();
        CFANode loopStartNode = this.loopStartStack.peek();
        BlankEdge blankEdge = new BlankEdge(continueStatement.getRawSignature(), fileloc.getStartingLineNumber(), prevNode, loopStartNode, "continue");
        this.addToCFA(blankEdge);
        CFANode nextNode = new CFANode(fileloc.getEndingLineNumber(), this.cfa.getFunctionName());
        this.locStack.push(nextNode);
    }

    private void handleLabelStatement(IASTLabelStatement labelStatement, IASTFileLocation fileloc) {
        String labelName = labelStatement.getName().toString();
        if (this.labelMap.containsKey(labelName)) {
            throw new CFAGenerationRuntimeException("Duplicate label " + labelName + " in function " + this.cfa.getFunctionName(), (IASTNode)labelStatement);
        }
        CFANode prevNode = this.locStack.pop();
        CFALabelNode labelNode = new CFALabelNode(fileloc.getStartingLineNumber(), this.cfa.getFunctionName(), labelName);
        this.cfaNodes.add(labelNode);
        this.locStack.push(labelNode);
        this.labelMap.put(labelName, labelNode);
        if (CFACreationUtils.isReachableNode(prevNode)) {
            BlankEdge blankEdge = new BlankEdge(labelStatement.getRawSignature(), fileloc.getStartingLineNumber(), prevNode, labelNode, "Label: " + labelName);
            this.addToCFA(blankEdge);
        }
        for (CFANode gotoNode : this.gotoLabelNeeded.get((Object)labelName)) {
            String description = "Goto: " + labelName;
            BlankEdge gotoEdge = new BlankEdge(description, gotoNode.getLineNumber(), gotoNode, labelNode, description);
            this.addToCFA(gotoEdge);
        }
        this.gotoLabelNeeded.removeAll((Object)labelName);
    }

    private void handleGotoStatement(IASTGotoStatement gotoStatement, IASTFileLocation fileloc) {
        String labelName = gotoStatement.getName().toString();
        CFANode prevNode = this.locStack.pop();
        CFANode labelNode = this.labelMap.get(labelName);
        if (labelNode != null) {
            BlankEdge gotoEdge = new BlankEdge(gotoStatement.getRawSignature(), fileloc.getStartingLineNumber(), prevNode, labelNode, "Goto: " + labelName);
            if (!labelNode.isLoopStart() && this.isPathFromTo(labelNode, prevNode)) {
                labelNode.setLoopStart();
            }
            this.addToCFA(gotoEdge);
        } else {
            this.gotoLabelNeeded.put((Object)labelName, (Object)prevNode);
        }
        CFANode nextNode = new CFANode(fileloc.getEndingLineNumber(), this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        this.locStack.push(nextNode);
    }

    private boolean isPathFromTo(CFANode fromNode, CFANode toNode) {
        ArrayDeque<CFANode> toProcessForwards = new ArrayDeque<CFANode>();
        ArrayDeque<CFANode> toProcessBackwards = new ArrayDeque<CFANode>();
        HashSet<CFANode> visitedForwards = new HashSet<CFANode>();
        HashSet<CFANode> visitedBackwards = new HashSet<CFANode>();
        toProcessForwards.addLast(fromNode);
        visitedForwards.add(fromNode);
        toProcessBackwards.addLast(toNode);
        visitedBackwards.add(toNode);
        while (!toProcessForwards.isEmpty() && !toProcessBackwards.isEmpty()) {
            CFANode currentForwards = (CFANode)toProcessForwards.removeLast();
            if (visitedBackwards.contains(currentForwards)) {
                return true;
            }
            for (CFAEdge child : CFAUtils.leavingEdges(currentForwards)) {
                if (!visitedForwards.add(child.getSuccessor())) continue;
                toProcessForwards.addLast(child.getSuccessor());
            }
            CFANode currentBackwards = (CFANode)toProcessBackwards.removeLast();
            if (visitedForwards.contains(currentBackwards)) {
                return true;
            }
            for (CFAEdge child : CFAUtils.enteringEdges(currentBackwards)) {
                if (!visitedBackwards.add(child.getPredecessor())) continue;
                toProcessBackwards.addLast(child.getPredecessor());
            }
        }
        return false;
    }

    private void handleReturnStatement(IASTReturnStatement returnStatement, IASTFileLocation fileloc) {
        CFANode prevNode = this.locStack.pop();
        CFAFunctionExitNode functionExitNode = this.cfa.getExitNode();
        ReturnStatementEdge edge = new ReturnStatementEdge(returnStatement.getRawSignature(), this.astCreator.convert(returnStatement), fileloc.getStartingLineNumber(), prevNode, functionExitNode);
        this.addToCFA(edge);
        CFANode nextNode = new CFANode(fileloc.getEndingLineNumber(), this.cfa.getFunctionName());
        this.cfaNodes.add(nextNode);
        this.locStack.push(nextNode);
    }

    private int handleSwitchStatement(IASTSwitchStatement statement, IASTFileLocation fileloc) {
        CFANode prevNode = this.locStack.pop();
        CFANode firstSwitchNode = new CFANode(fileloc.getStartingLineNumber(), this.cfa.getFunctionName());
        this.cfaNodes.add(firstSwitchNode);
        IASTExpression switchExpression = this.astCreator.convertExpressionWithoutSideEffects(statement.getControllerExpression());
        String rawSignature = "switch (" + statement.getControllerExpression().getRawSignature() + ")";
        String description = "switch (" + switchExpression.toASTString() + ")";
        this.addToCFA(new BlankEdge(rawSignature, fileloc.getStartingLineNumber(), prevNode, firstSwitchNode, description));
        this.switchExprStack.push(switchExpression);
        this.switchCaseStack.push(firstSwitchNode);
        CFALabelNode postSwitchNode = new CFALabelNode(fileloc.getEndingLineNumber(), this.cfa.getFunctionName(), "");
        this.cfaNodes.add(postSwitchNode);
        this.loopNextStack.push(postSwitchNode);
        this.locStack.push(postSwitchNode);
        this.locStack.push(new CFANode(fileloc.getStartingLineNumber(), this.cfa.getFunctionName()));
        statement.getBody().accept((ASTVisitor)this);
        CFANode lastNodeInSwitch = this.locStack.pop();
        CFANode lastNotCaseNode = this.switchCaseStack.pop();
        this.switchExprStack.pop();
        assert (postSwitchNode == this.loopNextStack.pop());
        assert (postSwitchNode == this.locStack.peek());
        assert (this.switchExprStack.size() == this.switchCaseStack.size());
        BlankEdge blankEdge = new BlankEdge("", lastNotCaseNode.getLineNumber(), lastNotCaseNode, postSwitchNode, "");
        this.addToCFA(blankEdge);
        BlankEdge blankEdge2 = new BlankEdge("", lastNodeInSwitch.getLineNumber(), lastNodeInSwitch, postSwitchNode, "");
        this.addToCFA(blankEdge2);
        return 1;
    }

    private void handleCaseStatement(IASTCaseStatement statement, IASTFileLocation fileloc) {
        int filelocStart = fileloc.getStartingLineNumber();
        IASTExpression switchExpr = this.switchExprStack.peek();
        IASTExpression caseExpr = this.astCreator.convertExpressionWithoutSideEffects(statement.getExpression());
        IASTBinaryExpression binExp = new IASTBinaryExpression(this.astCreator.convert(fileloc), switchExpr.getExpressionType(), switchExpr, caseExpr, IASTBinaryExpression.BinaryOperator.EQUALS);
        CFANode rootNode = this.switchCaseStack.pop();
        CFANode caseNode = new CFANode(filelocStart, this.cfa.getFunctionName());
        CFANode notCaseNode = new CFANode(filelocStart, this.cfa.getFunctionName());
        this.cfaNodes.add(caseNode);
        this.cfaNodes.add(notCaseNode);
        CFANode oldNode = this.locStack.pop();
        BlankEdge blankEdge = new BlankEdge("", filelocStart, oldNode, caseNode, "fall through");
        this.addToCFA(blankEdge);
        this.switchCaseStack.push(notCaseNode);
        this.locStack.push(caseNode);
        AssumeEdge assumeEdgeFalse = new AssumeEdge("!(" + binExp.toASTString() + ")", filelocStart, rootNode, notCaseNode, binExp, false);
        this.addToCFA(assumeEdgeFalse);
        AssumeEdge assumeEdgeTrue = new AssumeEdge(binExp.toASTString(), filelocStart, rootNode, caseNode, binExp, true);
        this.addToCFA(assumeEdgeTrue);
    }

    private void handleDefaultStatement(IASTDefaultStatement statement, IASTFileLocation fileloc) {
        int filelocStart = fileloc.getStartingLineNumber();
        CFANode rootNode = this.switchCaseStack.pop();
        CFANode caseNode = new CFANode(filelocStart, this.cfa.getFunctionName());
        CFANode notCaseNode = new CFANode(filelocStart, this.cfa.getFunctionName());
        this.cfaNodes.add(caseNode);
        this.cfaNodes.add(notCaseNode);
        CFANode oldNode = this.locStack.pop();
        BlankEdge blankEdge = new BlankEdge("", filelocStart, oldNode, caseNode, "fall through");
        this.addToCFA(blankEdge);
        this.switchCaseStack.push(notCaseNode);
        this.locStack.push(caseNode);
        BlankEdge trueEdge = new BlankEdge(statement.getRawSignature(), filelocStart, rootNode, caseNode, "default");
        this.addToCFA(trueEdge);
    }

    public int leave(org.eclipse.cdt.core.dom.ast.IASTStatement statement) {
        if (statement instanceof IASTIfStatement) {
            CFANode prevNode = this.locStack.pop();
            CFANode nextNode = this.locStack.peek();
            if (CFACreationUtils.isReachableNode(prevNode)) {
                for (CFAEdge prevEdge : ImmutableList.copyOf(CFAUtils.allEnteringEdges(prevNode))) {
                    if (!(prevEdge instanceof BlankEdge) || !prevEdge.getDescription().equals("")) continue;
                    CFANode prevPrevNode = prevEdge.getPredecessor();
                    assert (prevPrevNode.getNumLeavingEdges() == 1);
                    prevNode.removeEnteringEdge(prevEdge);
                    prevPrevNode.removeLeavingEdge(prevEdge);
                    BlankEdge blankEdge = new BlankEdge("", prevNode.getLineNumber(), prevPrevNode, nextNode, "");
                    this.addToCFA(blankEdge);
                }
                if (prevNode.getNumEnteringEdges() > 0) {
                    BlankEdge blankEdge = new BlankEdge("", prevNode.getLineNumber(), prevNode, nextNode, "");
                    this.addToCFA(blankEdge);
                }
            }
        } else if (statement instanceof IASTCompoundStatement) {
            this.scope.leaveBlock();
            if (statement.getPropertyInParent() == IASTWhileStatement.BODY) {
                CFANode prevNode = this.locStack.pop();
                CFANode startNode = this.loopStartStack.pop();
                if (CFACreationUtils.isReachableNode(prevNode)) {
                    BlankEdge blankEdge = new BlankEdge("", prevNode.getLineNumber(), prevNode, startNode, "");
                    this.addToCFA(blankEdge);
                }
                CFANode nextNode = this.loopNextStack.pop();
                assert (nextNode == this.locStack.peek());
            }
        } else if (statement instanceof IASTWhileStatement) {
            // empty if block
        }
        return 3;
    }

    public int visit(IASTProblem problem) {
        throw new CFAGenerationRuntimeException(problem.getMessage(), (IASTNode)problem);
    }

    private void addToCFA(CFAEdge edge) {
        CFACreationUtils.addEdgeToCFA(edge, this.logger);
    }

    private static enum CONDITION {
        NORMAL,
        ALWAYS_FALSE,
        ALWAYS_TRUE;

    }
}

